# frozen_string_literal: true

require_relative '../../../spec_helper'

describe Wpxf::WordPress::Xss do
  let(:subject) do
    Class.new(Wpxf::Module) do
      include Wpxf::WordPress::ReflectedXss
    end.new
  end

  describe '#new' do
    it 'sets up the desc key of the info store' do
      desc = %(
        This module prepares a payload and link that can be sent
        to an admin user which when visited with a valid session
        will create a new admin user which will be used to upload
        and execute the selected payload in the context of the
        web server.
      )

      expect(subject.module_desc.gsub(/\s+/, ' ')).to eq desc.gsub(/\s+/, ' ')
    end
  end

  describe '#run' do
    it 'raises an error if the url_with_xss method isn\'t implemented' do
      expect { subject.run }.to raise_error(
        'Required method "url_with_xss" has not been implemented'
      )
    end

    it 'starts a HTTP server if the module is configured properly' do
      invoked = false
      allow(subject).to receive(:start_http_server) do
        invoked = true
      end

      allow(subject).to receive(:puts).and_return nil
      allow(subject).to receive(:check_wordpress_and_online).and_return true
      allow(subject).to receive(:url_with_xss).and_return 'url'
      subject.run
      expect(invoked).to be true
    end
  end
end
