'use strict';

exports.__esModule = true;

exports.default = function (path, content, context) {

  if (context == null) throw new Error('need context to parse properly');

  var parserOptions = context.parserOptions;

  var parserPath = getParserPath(path, context);

  if (!parserPath) throw new Error('parserPath is required!');

  // hack: espree blows up with frozen options
  parserOptions = (0, _objectAssign2.default)({}, parserOptions);
  parserOptions.ecmaFeatures = (0, _objectAssign2.default)({}, parserOptions.ecmaFeatures);

  // always attach comments
  parserOptions.attachComment = true;

  // require the parser relative to the main module (i.e., ESLint)
  var parser = (0, _moduleRequire2.default)(parserPath);

  return parser.parse(content, parserOptions);
};

var _moduleRequire = require('./module-require');

var _moduleRequire2 = _interopRequireDefault(_moduleRequire);

var _objectAssign = require('object-assign');

var _objectAssign2 = _interopRequireDefault(_objectAssign);

var _path = require('path');

var _debug = require('debug');

var _debug2 = _interopRequireDefault(_debug);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var log = (0, _debug2.default)('eslint-plugin-import:parse');

function getParserPath(path, context) {
  var parsers = context.settings['import/parsers'];
  if (parsers != null) {
    var extension = (0, _path.extname)(path);
    for (var parserPath in parsers) {
      if (parsers[parserPath].indexOf(extension) > -1) {
        // use this alternate parser
        log('using alt parser:', parserPath);
        return parserPath;
      }
    }
  }
  // default to use ESLint parser
  return context.parserPath;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImNvcmUvcGFyc2UuanMiXSwibmFtZXMiOlsicGF0aCIsImNvbnRlbnQiLCJjb250ZXh0IiwiRXJyb3IiLCJwYXJzZXJPcHRpb25zIiwicGFyc2VyUGF0aCIsImdldFBhcnNlclBhdGgiLCJlY21hRmVhdHVyZXMiLCJhdHRhY2hDb21tZW50IiwicGFyc2VyIiwicGFyc2UiLCJsb2ciLCJwYXJzZXJzIiwic2V0dGluZ3MiLCJleHRlbnNpb24iLCJpbmRleE9mIl0sIm1hcHBpbmdzIjoiOzs7O2tCQU9lLFVBQVVBLElBQVYsRUFBZ0JDLE9BQWhCLEVBQXlCQyxPQUF6QixFQUFrQzs7QUFFL0MsTUFBSUEsV0FBVyxJQUFmLEVBQXFCLE1BQU0sSUFBSUMsS0FBSixDQUFVLGdDQUFWLENBQU47O0FBRjBCLE1BSXpDQyxhQUp5QyxHQUl2QkYsT0FKdUIsQ0FJekNFLGFBSnlDOztBQUsvQyxNQUFNQyxhQUFhQyxjQUFjTixJQUFkLEVBQW9CRSxPQUFwQixDQUFuQjs7QUFFQSxNQUFJLENBQUNHLFVBQUwsRUFBaUIsTUFBTSxJQUFJRixLQUFKLENBQVUseUJBQVYsQ0FBTjs7QUFFakI7QUFDQUMsa0JBQWdCLDRCQUFPLEVBQVAsRUFBV0EsYUFBWCxDQUFoQjtBQUNBQSxnQkFBY0csWUFBZCxHQUE2Qiw0QkFBTyxFQUFQLEVBQVdILGNBQWNHLFlBQXpCLENBQTdCOztBQUVBO0FBQ0FILGdCQUFjSSxhQUFkLEdBQThCLElBQTlCOztBQUVBO0FBQ0EsTUFBTUMsU0FBUyw2QkFBY0osVUFBZCxDQUFmOztBQUVBLFNBQU9JLE9BQU9DLEtBQVAsQ0FBYVQsT0FBYixFQUFzQkcsYUFBdEIsQ0FBUDtBQUNELEM7O0FBM0JEOzs7O0FBQ0E7Ozs7QUFDQTs7QUFDQTs7Ozs7O0FBRUEsSUFBTU8sTUFBTSxxQkFBTSw0QkFBTixDQUFaOztBQXdCQSxTQUFTTCxhQUFULENBQXVCTixJQUF2QixFQUE2QkUsT0FBN0IsRUFBc0M7QUFDcEMsTUFBTVUsVUFBVVYsUUFBUVcsUUFBUixDQUFpQixnQkFBakIsQ0FBaEI7QUFDQSxNQUFJRCxXQUFXLElBQWYsRUFBcUI7QUFDbkIsUUFBTUUsWUFBWSxtQkFBUWQsSUFBUixDQUFsQjtBQUNBLFNBQUssSUFBSUssVUFBVCxJQUF1Qk8sT0FBdkIsRUFBZ0M7QUFDOUIsVUFBSUEsUUFBUVAsVUFBUixFQUFvQlUsT0FBcEIsQ0FBNEJELFNBQTVCLElBQXlDLENBQUMsQ0FBOUMsRUFBaUQ7QUFDL0M7QUFDQUgsWUFBSSxtQkFBSixFQUF5Qk4sVUFBekI7QUFDQSxlQUFPQSxVQUFQO0FBQ0Q7QUFDRjtBQUNGO0FBQ0Q7QUFDQSxTQUFPSCxRQUFRRyxVQUFmO0FBQ0QiLCJmaWxlIjoiY29yZS9wYXJzZS5qcyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBtb2R1bGVSZXF1aXJlIGZyb20gJy4vbW9kdWxlLXJlcXVpcmUnXG5pbXBvcnQgYXNzaWduIGZyb20gJ29iamVjdC1hc3NpZ24nXG5pbXBvcnQgeyBleHRuYW1lIH0gZnJvbSAncGF0aCdcbmltcG9ydCBkZWJ1ZyBmcm9tICdkZWJ1ZydcblxuY29uc3QgbG9nID0gZGVidWcoJ2VzbGludC1wbHVnaW4taW1wb3J0OnBhcnNlJylcblxuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gKHBhdGgsIGNvbnRlbnQsIGNvbnRleHQpIHtcblxuICBpZiAoY29udGV4dCA9PSBudWxsKSB0aHJvdyBuZXcgRXJyb3IoJ25lZWQgY29udGV4dCB0byBwYXJzZSBwcm9wZXJseScpXG5cbiAgbGV0IHsgcGFyc2VyT3B0aW9ucyB9ID0gY29udGV4dFxuICBjb25zdCBwYXJzZXJQYXRoID0gZ2V0UGFyc2VyUGF0aChwYXRoLCBjb250ZXh0KVxuXG4gIGlmICghcGFyc2VyUGF0aCkgdGhyb3cgbmV3IEVycm9yKCdwYXJzZXJQYXRoIGlzIHJlcXVpcmVkIScpXG5cbiAgLy8gaGFjazogZXNwcmVlIGJsb3dzIHVwIHdpdGggZnJvemVuIG9wdGlvbnNcbiAgcGFyc2VyT3B0aW9ucyA9IGFzc2lnbih7fSwgcGFyc2VyT3B0aW9ucylcbiAgcGFyc2VyT3B0aW9ucy5lY21hRmVhdHVyZXMgPSBhc3NpZ24oe30sIHBhcnNlck9wdGlvbnMuZWNtYUZlYXR1cmVzKVxuXG4gIC8vIGFsd2F5cyBhdHRhY2ggY29tbWVudHNcbiAgcGFyc2VyT3B0aW9ucy5hdHRhY2hDb21tZW50ID0gdHJ1ZVxuXG4gIC8vIHJlcXVpcmUgdGhlIHBhcnNlciByZWxhdGl2ZSB0byB0aGUgbWFpbiBtb2R1bGUgKGkuZS4sIEVTTGludClcbiAgY29uc3QgcGFyc2VyID0gbW9kdWxlUmVxdWlyZShwYXJzZXJQYXRoKVxuXG4gIHJldHVybiBwYXJzZXIucGFyc2UoY29udGVudCwgcGFyc2VyT3B0aW9ucylcbn1cblxuZnVuY3Rpb24gZ2V0UGFyc2VyUGF0aChwYXRoLCBjb250ZXh0KSB7XG4gIGNvbnN0IHBhcnNlcnMgPSBjb250ZXh0LnNldHRpbmdzWydpbXBvcnQvcGFyc2VycyddXG4gIGlmIChwYXJzZXJzICE9IG51bGwpIHtcbiAgICBjb25zdCBleHRlbnNpb24gPSBleHRuYW1lKHBhdGgpXG4gICAgZm9yIChsZXQgcGFyc2VyUGF0aCBpbiBwYXJzZXJzKSB7XG4gICAgICBpZiAocGFyc2Vyc1twYXJzZXJQYXRoXS5pbmRleE9mKGV4dGVuc2lvbikgPiAtMSkge1xuICAgICAgICAvLyB1c2UgdGhpcyBhbHRlcm5hdGUgcGFyc2VyXG4gICAgICAgIGxvZygndXNpbmcgYWx0IHBhcnNlcjonLCBwYXJzZXJQYXRoKVxuICAgICAgICByZXR1cm4gcGFyc2VyUGF0aFxuICAgICAgfVxuICAgIH1cbiAgfVxuICAvLyBkZWZhdWx0IHRvIHVzZSBFU0xpbnQgcGFyc2VyXG4gIHJldHVybiBjb250ZXh0LnBhcnNlclBhdGhcbn1cbiJdfQ==