/*

Copyright Jesus Perez <jesusprubio gmail com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

const request = require('request');
const faker = require('faker');

const baseUrl = 'http://www.exploitsearch.net/json.php?q=';


// Constructor

function ExploitSearchClient(options) {
  this.exploits = (this.exploits) ? '1' : '0';
  this.timeout = options.timeout || 5000;
}


// Pubic methods

ExploitSearchClient.prototype.search = function search(query, callback) {
  const uri = baseUrl + query + '&e=' + this.exploits;
  const options = {
    uri: uri,
    method: 'GET',
    headers: {
      // to avoid blocking
      'User-Agent': faker.internet.userAgent(),
    },
    json: true,
    timeout: this.timeout,
  };

  request.get(options, function reqCb(error, response, body) {
    if (!error && response.statusCode === 200) {
      callback(null, body);
    } else {
      callback({
        msg: 'Making this request: ' + uri,
        error: error,
      });
    }
  });
};

module.exports = ExploitSearchClient;
