# CAI Pricing & Plans

> **Choose the Right Plan for Your Security Needs**
>
> From individual researchers to enterprise security teams, CAI offers flexible pricing tailored to your requirements.
>
> **[Get CAI PRO →](https://aliasrobotics.com/cybersecurityai.php)**

---

## Plan Overview

<div class="pricing-grid" markdown>

### CAI FREE

**€0 / forever**

Leading open-source framework for AI Security.  
Free for research purposes.

#### Included:
- ✅ AI Security Framework (300+ LLM Models)
- ✅ Built-in Security Tools
- ✅ Agent-based Architecture
- ✅ Guardrails Protection Built-in
- ✅ Community Support
- ✅ **Free for research** (non-commercial)

#### Limitations:
- ❌ No alias1 model access
- ❌ No Terminal UI (TUI)
- ❌ No parallel agent swarms
- ❌ No context monitoring
- ❌ No commercial license
- ⚠️ Framework updates ~6 months behind PRO

**[View on GitHub →](https://github.com/aliasrobotics/cai)**

---

### CAI PRO

**€350 / month / user**

Leading enterprise framework for AI Security with professional support.

#### Everything in FREE, plus:
- ✅ **Unlimited alias1 tokens**
- ✅ **Terminal User Interface (TUI)**
- ✅ **Multi-agent parallel execution** (100+ agents)
- ✅ **Context Monitoring** (`/context` command)
- ✅ **Commercial license** included
- ✅ **Professional support** (48h SLA)
- ✅ **GDPR & NIS2 compliant** European hosting
- ✅ **Advanced reporting** (PDF, Markdown, HTML)
- ✅ **Custom extensions** available
- ✅ **Latest features** (6+ months ahead of open source)
- ✅ **Priority Discord channel**

**🎯 Most Popular for Security Professionals**

**[Buy Now →](https://aliasrobotics.com/cybersecurityai.php)**

---

### CAI GOV & ENTERPRISE

**Custom Pricing**

Cybersecurity AI tailored to your organization requirements.  
Custom deployment options.

#### Everything in PRO, plus:
- ✅ **On-premise & air-gapped** alias1 deployment
- ✅ **Full privacy-by-design** architecture (alias0 arch)
- ✅ **Priority support & training**
- ✅ **Custom AI model fine-tuning** for your domain
- ✅ **Audit logging & forensics** capabilities
- ✅ **Dedicated account manager**
- ✅ **SLA guarantees** (custom)
- ✅ **Multi-platform deployment** (unlimited)
- ✅ **Custom integrations**

**Perfect for Large Teams, Government, & Regulated Industries**

**[Contact Sales →](mailto:contact@aliasrobotics.com?subject=CAI%20Enterprise%20Inquiry)**

</div>

---

## Detailed Feature Comparison

| Feature | FREE | PRO | GOV/ENTERPRISE |
|---------|------|-----|----------------|
| **💰 Pricing** | **Free** | **€350/month** | **Custom** |
| | | | |
| **🤖 Core Capabilities** | | | |
| AI Framework | ✅ (~6mo delay) | ✅ Latest | ✅ Latest + Custom |
| 300+ LLM Models | ✅ BYO Keys | ✅ BYO Keys | ✅ BYO + Private |
| Built-in Security Tools | ✅ Full Suite | ✅ Full Suite | ✅ Full Suite + Custom |
| Agent-based Architecture | ✅ All Patterns | ✅ All Patterns | ✅ All + Custom |
| Command Line Interface | ✅ Yes | ✅ Yes | ✅ Yes |
| | | | |
| **🚀 Alias1 Model** | | | |
| Alias1 Access | ❌ | ✅ Unlimited Tokens | ✅ Unlimited + On-prem |
| #2 CAIBench Rank | ❌ | ✅ Yes | ✅ Yes |
| Zero Refusals | ❌ | ✅ Yes | ✅ Yes |
| European Hosting | ❌ | ✅ Yes | ✅ + On-premise Option |
| | | | |
| **🖥️ User Interfaces** | | | |
| Terminal UI (TUI) | ❌ | ✅ Multi-terminal | ✅ Multi-terminal + Custom |
| Parallel Agent Execution | ❌ | ✅ 100+ agents | ✅ Unlimited |
| Context Monitoring | ❌ | ✅ `/context` | ✅ + Analytics Dashboard |
| Keyboard Shortcuts | ❌ | ✅ Full Set | ✅ Full Set + Custom |
| Team Presets | ❌ | ✅ 11 Teams | ✅ Unlimited Custom |
| | | | |
| **💬 Support** | | | |
| Community Discord | ✅ Yes | ✅ Yes | ✅ Yes |
| Email Support | ❌ | ✅ 48h SLA | ✅ Custom SLA |
| Priority Discord Channel | ❌ | ✅ Yes | ✅ Yes |
| Quarterly Strategy Calls | ❌ | ✅ Yes | ✅ Yes + More Frequent |
| Dedicated Account Manager | ❌ | ❌ | ✅ Yes |
| On-site Training | ❌ | ❌ | ✅ Available |
| | | | |
| **🛡️ Security & Compliance** | | | |
| GDPR Compliant | ✅ Yes | ✅ Yes | ✅ Yes |
| NIS2 Directive Ready | ✅ Yes | ✅ Yes | ✅ Yes |
| EU Data Centers Only | ✅ Yes | ✅ Yes | ✅ + On-premise |
| Guardrails | ✅ Basic | ✅ 4-layer | ✅ Configurable |
| Audit Logging | ❌ | ✅ Basic | ✅ Forensics-grade |
| | | | |
| **📝 Reporting & Documentation** | | | |
| Basic Reporting | ✅ CLI Output | ✅ CLI + Advanced | ✅ Custom Templates |
| CTF Writeups | ❌ | ✅ Automated | ✅ Automated + Branded |
| Pentest Reports | ❌ | ✅ Executive + Technical | ✅ Compliance-ready |
| Export Formats | ✅ Markdown | ✅ MD, PDF, HTML, JSON | ✅ All + Custom |
| | | | |
| **🔧 Customization** | | | |
| Custom Agents | ❌ | ✅ On Request | ✅ Included |
| Custom Extensions | ❌ | ✅ Available | ✅ Included |
| Tool Integration | ❌ | ✅ On Request | ✅ Full Integration Support |
| API Wrappers | ❌ | ❌ | ✅ Custom Development |
| Model Fine-tuning | ❌ | ❌ | ✅ Domain-specific |
| | | | |
| **🏢 Licensing** | | | |
| Commercial Use | ❌ Research Only | ✅ Full Commercial | ✅ Full + Redistribution |
| Academic Research | ✅ Yes | ✅ Yes | ✅ Yes |
| Bug Bounty (paid) | ❌ | ✅ Yes | ✅ Yes |
| Security Consulting | ❌ | ✅ Yes | ✅ Yes |
| Enterprise Deployment | ❌ | ✅ Yes | ✅ Yes |
| | | | |
| **🐳 Deployment** | | | |
| Cloud (Your Infra) | ✅ Yes | ✅ Yes | ✅ Yes |
| On-premise | ✅ Self-hosted | ✅ Self-hosted | ✅ + Managed |
| Air-gapped Networks | ❌ | ❌ | ✅ Supported |
| Multi-platform | ✅ Limited | ✅ Unlimited | ✅ Unlimited + Support |

---

## Cost Comparison: Alias1 vs Competitors

### Monthly Cost for 1 Billion Tokens

Based on CAI's average text generation profile: **15,430 input / 436 output tokens per request**

<div class="cost-comparison" markdown>

| Provider | Monthly Cost | Annual Cost | vs CAI PRO |
|----------|--------------|-------------|------------|
| **GPT-5** | €1,491 | €17,892 | ❌ **4.3× more expensive** |
| **Claude Sonnet 4.5** | €3,330 | €39,960 | ❌ **9.5× more expensive** |
| **Claude Opus 4.1** | €16,650 | €199,800 | ❌ **47.6× more expensive** |
| **🤖 CAI PRO (∞ alias1)** | **€350** | **€4,200** | ✅ **Unlimited included** |

### Annual Savings with CAI PRO

| vs Provider | Monthly Savings | Annual Savings |
|-------------|-----------------|----------------|
| vs GPT-5 | €1,141 | €13,692 |
| vs Claude Sonnet 4.5 | €2,980 | €35,760 |
| vs Claude Opus 4.1 | €16,300 | €195,600 |

**💰 ROI: CAI PRO pays for itself in the first month** for teams using more than ~230M tokens/month.

</div>

---

## Frequently Asked Questions

### How does billing work?

**CAI PRO:**
- **Monthly subscription**: Billed on the 1st of each month
- **Payment methods**: Credit card, bank transfer (annual plans)
- **Currency**: EUR (€)
- **VAT**: Excluded from listed prices (added at checkout for EU customers)
- **Cancellation**: Cancel anytime, access until end of billing period

**CAI GOV/ENTERPRISE:**
- **Custom billing**: Annual, quarterly, or monthly
- **Purchase orders**: Accepted for enterprise plans
- **Invoicing**: NET 30 terms available
- **Multi-year contracts**: Discounts available

### What happens if I exceed fair use limits?

CAI PRO includes **unlimited alias1 tokens** subject to fair use:

**Fair use policy:**
- Typical usage: 100M - 10B tokens/month ✅ **No issues**
- Heavy usage: 10B - 100B tokens/month ✅ **Monitored but allowed**
- Extreme usage: >100B tokens/month ⚠️ **Contact us to upgrade to Enterprise**

We've never had to enforce limits—most users stay well within fair use.

### Can I switch plans?

Yes! You can upgrade or downgrade anytime:

**Upgrade (FREE → PRO):**
- Instant access to PRO features
- Billed monthly starting immediately

**Downgrade (PRO → FREE):**
- Access to PRO features until end of billing period
- Automatic switch to FREE plan
- Retain all data and configurations

**Contact Sales for Enterprise:**
- Custom migration path
- Dedicated onboarding support

### Do you offer academic discounts?

Yes! We offer special pricing for universities and research institutions:

**Academic CAI PRO:**
- **Contact**: contact@aliasrobotics.com with:
  - Institutional affiliation
  - Research project description
  - Number of users needed

### Can I pay annually?

Yes! Annual plans available:

**CAI PRO Annual:**
- **€4,200/year** 
- **Benefits**: Same as monthly + priority support

**Contact contact@aliasrobotics.com for annual billing**

### What if I need more than alias1?

CAI PRO includes:
- **Unlimited alias1**: Use as much as you need
- **BYO API keys**: Use your own keys for GPT-5, Claude, Gemini, etc.

### Can I schedule a demo?

Yes! Contact us:

**CAI PRO demos:**
- Contact contact@aliasrobotics.com
- Schedule a live demo with our team
- See TUI, alias1, and advanced features in action

We don't offer free PRO trials, but CAI FREE lets you evaluate the framework before committing.

### Can I use CAI PRO for bug bounties?

**Yes!** CAI PRO includes a **full commercial license**, which covers:

✅ **Authorized bug bounty programs** (HackerOne, Bugcrowd, etc.)  
✅ **Security consulting services**  
✅ **Penetration testing** for clients  
✅ **Enterprise security operations**

Bug bounties discovered with CAI PRO:
- **$2,500+ earned** by CAI users in documented bounties
- Vulnerabilities found in Ecoforest, MiR, Mercado Libre, and more

[View Case Studies →](https://aliasrobotics.com/case-studies-robot-cybersecurity.php)

---

## Choose Your Plan

<div class="pricing-cta" markdown>

### 🆓 **CAI FREE**

**Perfect for:**
- Individual researchers
- Students & academics
- Open-source contributors
- Personal learning

**[Get Started (GitHub) →](https://github.com/aliasrobotics/cai)**

---

### 🚀 **CAI PRO** (Most Popular)

**Perfect for:**
- Security professionals
- Bug bounty hunters
- Small security teams (1-5)
- Security consultants

**€350/month** · No contracts · Cancel anytime

**[Buy CAI PRO →](https://aliasrobotics.com/cybersecurityai.php)**

---

### 🏢 **CAI GOV & ENTERPRISE**

**Perfect for:**
- Large security teams (20+)
- Government agencies
- Regulated industries
- Custom requirements

**Custom pricing** · Volume discounts · SLA guarantees

**[Contact Sales →](mailto:contact@aliasrobotics.com?subject=CAI%20Enterprise%20Inquiry)**

</div>

---

## Next Steps

- **[Explore Features](cai_pro_features.md)** - See what's included in CAI PRO
- **[Learn About Alias1](cai_pro_alias1.md)** - Understand our flagship model
- **[Quick Start Guide](cai_pro_quickstart.md)** - Get started in 5 minutes
- **[Contact Sales](cai_pro_contact.md)** - Questions? We're here to help

---

<small>
*All prices exclude VAT. Volume discounts available for teams.*  
*Questions about pricing? Contact **contact@aliasrobotics.com***
</small>

