/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.autoupdate.ui.LocalDownloadSupport;
import org.netbeans.modules.autoupdate.ui.LocallyDownloadedTableModel;
import org.netbeans.modules.autoupdate.ui.PluginManagerUI;
import org.netbeans.modules.autoupdate.ui.UnitCategoryTableModel;
import org.netbeans.modules.autoupdate.ui.UnitTab;
import org.openide.util.Exceptions;
import org.openide.util.NbCollections;

final class LocallDownloadDnD
implements DropTargetListener {
    private final LocalDownloadSupport localDownloadSupport;
    private final LocallyDownloadedTableModel model;
    private final PluginManagerUI outer;
    private DataFlavor accept;
    private Object value;

    LocallDownloadDnD(LocalDownloadSupport localDownloadSupport, LocallyDownloadedTableModel model, PluginManagerUI outer) {
        this.model = model;
        this.outer = outer;
        this.localDownloadSupport = localDownloadSupport;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        this.accept = null;
        this.value = null;
        for (DataFlavor dataFlavor : dtde.getCurrentDataFlavors()) {
            Object obj = null;
            try {
                obj = dtde.getTransferable().getTransferData(dataFlavor);
            }
            catch (Exception ex) {
                continue;
            }
            if (dataFlavor.isFlavorJavaFileListType()) {
                this.accept = dataFlavor;
                this.value = obj;
                break;
            }
            if (!"text".equals(dataFlavor.getPrimaryType()) || !"uri-list".equals(dataFlavor.getSubType()) || dataFlavor.getRepresentationClass() != String.class) continue;
            this.accept = dataFlavor;
            this.value = (String)obj;
            break;
        }
        if (this.accept != null) {
            dtde.acceptDrag(3);
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        if (this.accept == null) {
            dtde.dropComplete(false);
            return;
        }
        try {
            dtde.acceptDrop(3);
            List<File> files = null;
            if (this.value instanceof String) {
                files = new ArrayList();
                for (String v : ((String)this.value).split("\n")) {
                    File f = new File(new URI(v.trim()));
                    assert (f.exists()) : "File shall exist: " + f;
                    files.add(f);
                }
            }
            if (this.value instanceof List) {
                files = NbCollections.checkedListByCopy((List)((List)this.value), File.class, (boolean)true);
            }
            if (files != null) {
                UnitTab lt = this.outer.findTabForModel(this.model);
                assert (lt != null);
                Map<String, Boolean> state = UnitCategoryTableModel.captureState(this.model.getUnits());
                this.localDownloadSupport.addUpdateUnits(files.toArray(new File[0]));
                lt.updateTab(state);
                this.outer.setSelectedTab(lt);
            }
            dtde.dropComplete(true);
        }
        catch (Exception ex) {
            dtde.dropComplete(false);
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

