/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.wizards;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.autoupdate.ui.wizards.InstallStep;
import org.netbeans.modules.autoupdate.ui.wizards.OperationDescriptionStep;
import org.netbeans.modules.autoupdate.ui.wizards.OperationPanel;
import org.netbeans.modules.autoupdate.ui.wizards.OperationWizardModel;
import org.netbeans.modules.autoupdate.ui.wizards.PanelBodyContainer;
import org.netbeans.modules.autoupdate.ui.wizards.UninstallUnitWizardModel;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class UninstallStep
implements WizardDescriptor.FinishablePanel<WizardDescriptor> {
    private final Logger err = Logger.getLogger("org.netbeans.modules.autoupdate.ui.wizards.UninstallStep");
    private OperationPanel panel;
    private PanelBodyContainer component;
    private UninstallUnitWizardModel model = null;
    private WizardDescriptor wd = null;
    private OperationSupport.Restarter restarter = null;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private static final String HEAD_UNINSTALL = "UninstallStep_Header_Uninstall_Head";
    private static final String CONTENT_UNINSTALL = "UninstallStep_Header_Uninstall_Content";
    private static final String HEAD_DEACTIVATE = "UninstallStep_Header_Deactivate_Head";
    private static final String CONTENT_DEACTIVATE = "UninstallStep_Header_Deactivate_Content";
    private static final String HEAD_ACTIVATE = "UninstallStep_Header_Activate_Head";
    private static final String CONTENT_ACTIVATE = "UninstallStep_Header_Activate_Content";
    private static final String HEAD_DEACTIVATE_DONE = "UninstallStep_Header_DeactivateDone_Head";
    private static final String CONTENT_DEACTIVATE_DONE = "UninstallStep_Header_DeactivateDone_Content";
    private static final String HEAD_ACTIVATE_DONE = "UninstallStep_Header_ActivateDone_Head";
    private static final String CONTENT_ACTIVATE_DONE = "UninstallStep_Header_ActivateDone_Content";
    private static final String HEAD_UNINSTALL_DONE = "UninstallStep_Header_UninstallDone_Head";
    private static final String CONTENT_UNINSTALL_DONE = "UninstallStep_Header_UninstallDone_Content";
    private static final String HEAD_DEACTIVATE_FAILED = "UninstallStep_Header_DeactivateFailed_Head";
    private static final String CONTENT_DEACTIVATE_FAILED = "UninstallStep_Header_DeactivateFailed_Content";
    private static final String HEAD_ACTIVATE_FAILED = "UninstallStep_Header_ActivateFailed_Head";
    private static final String CONTENT_ACTIVATE_FAILED = "UninstallStep_Header_ActivateFailed_Content";
    private static final String HEAD_UNINSTALL_FAILED = "UninstallStep_Header_UninstallFailed_Head";
    private static final String CONTENT_UNINSTALL_FAILED = "UninstallStep_Header_UninstallFailed_Content";
    private static final String UNINSTALL_PROGRESS_NAME = "UninstallStep_ProgressName_Uninstall";
    private static final String ACTIVATE_PROGRESS_NAME = "UninstallStep_ProgressName_Activate";
    private static final String DEACTIVATE_PROGRESS_NAME = "UninstallStep_ProgressName_Deactivate";
    private static final String HEAD_RESTART = "UninstallStep_Header_Restart_Head";
    private static final String CONTENT_RESTART = "UninstallStep_Header_Restart_Content";
    private boolean wasStored = false;

    public UninstallStep(UninstallUnitWizardModel model) {
        this.model = model;
    }

    public boolean isFinishPanel() {
        return true;
    }

    public PanelBodyContainer getComponent() {
        if (this.component == null) {
            this.panel = new OperationPanel(false);
            this.panel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("run-action".equals(evt.getPropertyName())) {
                        UninstallStep.this.doAction();
                    }
                }
            });
            switch (this.model.getOperation()) {
                case UNINSTALL: {
                    this.component = new PanelBodyContainer(this.getBundle(HEAD_UNINSTALL, new Object[0]), this.getBundle(CONTENT_UNINSTALL, new Object[0]), this.panel);
                    break;
                }
                case ENABLE: {
                    this.component = new PanelBodyContainer(this.getBundle(HEAD_ACTIVATE, new Object[0]), this.getBundle(CONTENT_ACTIVATE, new Object[0]), this.panel);
                    break;
                }
                case DISABLE: {
                    this.component = new PanelBodyContainer(this.getBundle(HEAD_DEACTIVATE, new Object[0]), this.getBundle(CONTENT_DEACTIVATE, new Object[0]), this.panel);
                    break;
                }
                default: {
                    assert (false) : "Unknown OperationType " + (Object)((Object)this.model.getOperation());
                    break;
                }
            }
            this.component.setPreferredSize(OperationWizardModel.PREFFERED_DIMENSION);
        }
        return this.component;
    }

    private void doAction() {
        OperationSupport.Restarter r = null;
        try {
            r = this.handleAction();
            if (r != null) {
                this.presentActionNeedsRestart(r);
            } else {
                this.presentActionDone();
            }
        }
        catch (OperationException ex) {
            this.presentActionFailed(ex);
        }
        this.fireChange();
    }

    private OperationSupport.Restarter handleAction() throws OperationException {
        assert (this.model.getBaseContainer() != null) : "getBaseContainers() returns not null container.";
        OperationSupport support = (OperationSupport)this.model.getBaseContainer().getSupport();
        assert (support != null) : "OperationSupport cannot be null because OperationContainer contains elements: " + this.model.getBaseContainer().listAll() + " and invalid elements " + this.model.getBaseContainer().listInvalid();
        ProgressHandle handle = null;
        switch (this.model.getOperation()) {
            case UNINSTALL: {
                handle = ProgressHandleFactory.createHandle((String)this.getBundle(UNINSTALL_PROGRESS_NAME, new Object[0]));
                break;
            }
            case ENABLE: {
                handle = ProgressHandleFactory.createHandle((String)this.getBundle(ACTIVATE_PROGRESS_NAME, new Object[0]));
                break;
            }
            case DISABLE: {
                handle = ProgressHandleFactory.createHandle((String)this.getBundle(DEACTIVATE_PROGRESS_NAME, new Object[0]));
                break;
            }
            default: {
                assert (false) : "Unknown OperationType " + (Object)((Object)this.model.getOperation());
                break;
            }
        }
        JComponent progressComponent = ProgressHandleFactory.createProgressComponent(handle);
        JLabel mainLabel = ProgressHandleFactory.createMainLabelComponent((ProgressHandle)handle);
        JLabel detailLabel = ProgressHandleFactory.createDetailLabelComponent((ProgressHandle)handle);
        this.model.modifyOptionsForDisabledCancel(this.wd);
        this.panel.waitAndSetProgressComponents(mainLabel, progressComponent, detailLabel);
        OperationSupport.Restarter r = null;
        try {
            r = support.doOperation(handle);
            this.panel.waitAndSetProgressComponents(mainLabel, progressComponent, new JLabel(this.getBundle("UninstallStep_Done", new Object[0])));
        }
        catch (OperationException ex) {
            this.err.log(Level.INFO, ex.getMessage(), ex);
            this.panel.waitAndSetProgressComponents(mainLabel, progressComponent, new JLabel(this.getBundle("UninstallStep_Failed", ex.getLocalizedMessage())));
            throw ex;
        }
        return r;
    }

    private void presentActionDone() {
        switch (this.model.getOperation()) {
            case UNINSTALL: {
                this.component.setHeadAndContent(this.getBundle(HEAD_UNINSTALL_DONE, new Object[0]), this.getBundle(CONTENT_UNINSTALL_DONE, new Object[0]));
                break;
            }
            case ENABLE: {
                this.component.setHeadAndContent(this.getBundle(HEAD_ACTIVATE_DONE, new Object[0]), this.getBundle(CONTENT_ACTIVATE_DONE, new Object[0]));
                break;
            }
            case DISABLE: {
                this.component.setHeadAndContent(this.getBundle(HEAD_DEACTIVATE_DONE, new Object[0]), this.getBundle(CONTENT_DEACTIVATE_DONE, new Object[0]));
                break;
            }
            default: {
                assert (false) : "Unknown OperationType " + (Object)((Object)this.model.getOperation());
                break;
            }
        }
        this.model.modifyOptionsForDoClose(this.wd);
        switch (this.model.getOperation()) {
            case UNINSTALL: {
                this.panel.setBody(this.getBundle("UninstallStep_UninstallDone_Text", new Object[0]), this.model.getAllVisibleUpdateElements());
                break;
            }
            case ENABLE: {
                this.panel.setBody(this.getBundle("UninstallStep_ActivateDone_Text", new Object[0]), this.model.getAllVisibleUpdateElements());
                break;
            }
            case DISABLE: {
                this.panel.setBody(this.getBundle("UninstallStep_DeactivateDone_Text", new Object[0]), this.model.getAllVisibleUpdateElements());
                break;
            }
            default: {
                assert (false) : "Unknown OperationType " + (Object)((Object)this.model.getOperation());
                break;
            }
        }
    }

    private void presentActionFailed(OperationException ex) {
        switch (this.model.getOperation()) {
            case UNINSTALL: {
                this.component.setHeadAndContent(this.getBundle(HEAD_UNINSTALL_FAILED, new Object[0]), this.getBundle(CONTENT_UNINSTALL_FAILED, new Object[0]));
                break;
            }
            case ENABLE: {
                this.component.setHeadAndContent(this.getBundle(HEAD_ACTIVATE_FAILED, new Object[0]), this.getBundle(CONTENT_ACTIVATE_FAILED, new Object[0]));
                break;
            }
            case DISABLE: {
                this.component.setHeadAndContent(this.getBundle(HEAD_DEACTIVATE_FAILED, new Object[0]), this.getBundle(CONTENT_DEACTIVATE_FAILED, new Object[0]));
                break;
            }
            default: {
                assert (false) : "Unknown OperationType " + (Object)((Object)this.model.getOperation());
                break;
            }
        }
        this.model.modifyOptionsForFailed(this.wd);
        switch (this.model.getOperation()) {
            case UNINSTALL: {
                this.panel.setBody(this.getBundle("UninstallStep_UninstallFailed_Text", ex.getLocalizedMessage()), this.model.getAllVisibleUpdateElements());
                break;
            }
            case ENABLE: {
                this.panel.setBody(this.getBundle("UninstallStep_ActivateFailed_Text", ex.getLocalizedMessage()), OperationDescriptionStep.prepareBrokenDependenciesForShow(this.model));
                break;
            }
            case DISABLE: {
                this.panel.setBody(this.getBundle("UninstallStep_DeactivateFailed_Text", ex.getLocalizedMessage()), this.model.getAllVisibleUpdateElements());
                break;
            }
            default: {
                assert (false) : "Unknown OperationType " + (Object)((Object)this.model.getOperation());
                break;
            }
        }
    }

    private void presentActionNeedsRestart(OperationSupport.Restarter r) {
        this.component.setHeadAndContent(this.getBundle(HEAD_RESTART, new Object[0]), this.getBundle(CONTENT_RESTART, new Object[0]));
        this.model.modifyOptionsForDoClose(this.wd, true);
        this.restarter = r;
        this.panel.setRestartButtonsVisible(true);
        switch (this.model.getOperation()) {
            case UNINSTALL: {
                this.panel.setBody(this.getBundle("UninstallStep_UninstallDone_Text", new Object[0]), this.model.getAllVisibleUpdateElements());
                break;
            }
            case ENABLE: {
                this.panel.setBody(this.getBundle("UninstallStep_ActivateDone_Text", new Object[0]), this.model.getAllVisibleUpdateElements());
                break;
            }
            case DISABLE: {
                this.panel.setBody(this.getBundle("UninstallStep_DeactivateDone_Text", new Object[0]), this.model.getAllVisibleUpdateElements());
                break;
            }
            default: {
                assert (false) : "Unknown OperationType " + (Object)((Object)this.model.getOperation());
                break;
            }
        }
    }

    public HelpCtx getHelp() {
        return null;
    }

    public void readSettings(WizardDescriptor wd) {
        this.wd = wd;
        this.wasStored = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void storeSettings(WizardDescriptor wd) {
        assert (!WizardDescriptor.PREVIOUS_OPTION.equals(wd.getValue())) : "Cannot invoke Back in this case.";
        if (this.wasStored) {
            return;
        }
        this.wasStored = true;
        if (WizardDescriptor.CANCEL_OPTION.equals(wd.getValue()) || WizardDescriptor.CLOSED_OPTION.equals(wd.getValue())) {
            try {
                this.model.doCleanup(true);
                return;
            }
            catch (OperationException x) {
                Logger.getLogger(UninstallStep.class.getName()).log(Level.INFO, x.getMessage(), x);
            }
            return;
        }
        if (this.restarter != null) {
            final OperationSupport support = (OperationSupport)this.model.getBaseContainer().getSupport();
            assert (support != null) : "OperationSupport cannot be null because OperationContainer contains elements: " + this.model.getBaseContainer().listAll() + " and invalid elements " + this.model.getBaseContainer().listInvalid();
            if (this.panel.restartNow()) {
                try {
                    support.doRestart(this.restarter, null);
                    return;
                }
                catch (OperationException x) {
                    this.err.log(Level.INFO, x.getMessage(), x);
                }
                return;
            }
            support.doRestartLater(this.restarter);
            try {
                this.model.doCleanup(false);
            }
            catch (OperationException x) {
                this.err.log(Level.INFO, x.getMessage(), x);
            }
            Runnable onMouseClick = new Runnable(){

                @Override
                public void run() {
                    try {
                        support.doRestart(UninstallStep.this.restarter, null);
                    }
                    catch (OperationException x) {
                        UninstallStep.this.err.log(Level.INFO, x.getMessage(), x);
                    }
                }
            };
            InstallStep.notifyRestartNeeded(onMouseClick, this.getBundle("UninstallSupport_RestartNeeded", new Object[0]));
            return;
        }
        try {
            this.model.doCleanup(!WizardDescriptor.FINISH_OPTION.equals(wd.getValue()));
            return;
        }
        catch (OperationException x) {
            this.err.log(Level.INFO, x.getMessage(), x);
        }
    }

    public boolean isValid() {
        return true;
    }

    public synchronized void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList<ChangeListener> templist;
        ChangeEvent e = new ChangeEvent(this);
        UninstallStep uninstallStep = this;
        synchronized (uninstallStep) {
            templist = new ArrayList<ChangeListener>(this.listeners);
        }
        for (ChangeListener l : templist) {
            l.stateChanged(e);
        }
    }

    private String getBundle(String key, Object ... params) {
        return NbBundle.getMessage(InstallStep.class, (String)key, (Object[])params);
    }
}

