/*
 * Decompiled with CFR 0.152.
 */
package org.officelaf;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPanelUI;

public class OfficePanelUI
extends BasicPanelUI {
    private static final Color GRAY_10 = new Color(10, 10, 10);
    public static final Color GRAY_76 = new Color(76, 76, 76);
    private static final OfficePanelUI DEFAULT = new OfficePanelUI();
    private static final OfficePanelUI TRANSPARENT = new OfficePanelUI(Type.TRANSPARENT);
    private static final OfficePanelUI SOLID = new OfficePanelUI(Type.SOLID);
    private static Boolean mainBgIsSet = false;
    private Type type = Type.DEFAULT;

    public OfficePanelUI(Type type) {
        this.type = type;
    }

    public OfficePanelUI() {
    }

    public static ComponentUI createUI(final JComponent jComponent) {
        OfficePanelUI officePanelUI = DEFAULT;
        String string = jComponent.getClass().getName();
        if (string.compareTo("org.netbeans.core.windows.view.ui.MultiSplitPane") == 0 || string.compareTo("org.netbeans.core.windows.view.EditorView$EditorAreaComponent") == 0 || string.compareTo("org.netbeans.core.windows.view.ui.slides.SlideBarContainer$VisualPanel") == 0) {
            if (!mainBgIsSet.booleanValue()) {
                jComponent.addHierarchyListener(new HierarchyListener(){

                    @Override
                    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                        if (jComponent.getParent() != null && jComponent.getParent() instanceof JPanel && !mainBgIsSet.booleanValue()) {
                            ((JPanel)jComponent.getParent()).setUI(new OfficePanelUI(Type.MAIN_BG));
                            mainBgIsSet = true;
                        }
                    }
                });
            }
            officePanelUI = SOLID;
        }
        return officePanelUI;
    }

    @Override
    protected void installDefaults(JPanel jPanel) {
        super.installDefaults(jPanel);
        if (this.type == Type.TRANSPARENT) {
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel.setOpaque(false);
        } else if (this.type == Type.SOLID) {
            jPanel.setBackground(GRAY_76);
            jPanel.setOpaque(true);
        }
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        switch (this.type) {
            case MAIN_BG: {
                graphics2D.setColor(GRAY_76);
                graphics2D.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
                break;
            }
            case TRANSPARENT: {
                break;
            }
            default: {
                if (!jComponent.isOpaque()) break;
                graphics2D.setColor(jComponent.getBackground());
                graphics2D.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
            }
        }
        this.paint(graphics, jComponent);
    }

    private static enum Type {
        MAIN_BG,
        TRANSPARENT,
        SOLID,
        DEFAULT;

    }
}

