/*
 * Decompiled with CFR 0.152.
 */
package org.officelaf;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.awt.StatusDisplayer;
import org.openide.awt.StatusLineElementProvider;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public class StatusBar
extends JPanel
implements ChangeListener,
Runnable {
    public static final Color GRAY_17 = new Color(17, 17, 17);
    public static final Color GRAY_72 = new Color(72, 72, 72);
    public static final Color GRAY_124 = new Color(124, 124, 124);
    public static final Color GRAY_13 = new Color(13, 13, 13);
    public static final Color GRAY_47 = new Color(47, 48, 48);
    public static final Color GRAY_69 = new Color(69, 69, 69);
    public static final Color GRAY_76 = new Color(76, 76, 76);
    public static final Color TOPLINE = new Color(97, 106, 118);
    public static final Color TOP_67 = new Color(67, 71, 82);
    public static final Color TOP_62 = new Color(62, 65, 75);
    public static final Color TOP_60 = new Color(60, 64, 74);
    public static final Color MIDDLE_47 = new Color(47, 48, 48);
    public static final Color MIDDLE_60 = new Color(60, 60, 60);
    public static final Color DRAG_LIGHT = new Color(221, 224, 227);
    public static final Color DRAG_DARK = new Color(145, 153, 164);
    private static int SURVIVING_TIME = Integer.getInteger("org.openide.awt.StatusDisplayer.DISPLAY_TIME", 5000);
    private static Lookup.Result<StatusLineElementProvider> result;
    private static JPanel innerIconsPanel;
    protected BufferedImage dragImage;
    protected BufferedImage verticalImage;
    protected Object clearing;
    private StatusDisplayer d = StatusDisplayer.getDefault();
    private JLabel displayer;

    public StatusBar() {
        super(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 12));
        this.setPreferredSize(new Dimension(100, 20));
        this.setBackground(GRAY_47);
        this.setName("statusLine");
        this.displayer = new JLabel();
        this.displayer.setForeground(Color.WHITE);
        this.add((Component)this.displayer, "Center");
        StatusBar.decoratePanel(this);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.run();
        this.d.addChangeListener((ChangeListener)this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.d.removeChangeListener((ChangeListener)this);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.run();
        } else {
            SwingUtilities.invokeLater(this);
        }
    }

    @Override
    public void run() {
        String string = this.d.getStatusText();
        this.setForeground(UIManager.getColor("Label.foreground"));
        this.displayer.setText(string);
        if (SURVIVING_TIME != 0) {
            Object object;
            this.clearing = object = new Object();
            if (!"".equals(string)) {
                new Updater(object).schedule();
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(100, super.getPreferredSize().height);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, super.getMinimumSize().height);
    }

    static JPanel getStatusLineElements(JPanel jPanel) {
        Collection collection;
        if (result == null) {
            result = Lookup.getDefault().lookup(new Lookup.Template(StatusLineElementProvider.class));
            result.addLookupListener((LookupListener)new StatusLineElementsListener(jPanel));
        }
        if ((collection = result.allInstances()) == null || collection.isEmpty()) {
            return null;
        }
        JPanel jPanel2 = new JPanel(new FlowLayout(2, 0, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 2));
        jPanel2.setOpaque(false);
        boolean bl = false;
        for (StatusLineElementProvider statusLineElementProvider : collection) {
            Component component = statusLineElementProvider.getStatusLineElement();
            if (component == null) continue;
            bl = true;
            if (component instanceof JComponent) {
                ((JComponent)component).setOpaque(false);
            }
            StatusBar.setForeground(component);
            jPanel2.add(component);
        }
        return bl ? jPanel2 : null;
    }

    protected static void setForeground(Component component) {
        if (component != null) {
            component.setForeground(Color.WHITE);
        }
        if (component instanceof Container) {
            for (Component component2 : ((Container)component).getComponents()) {
                StatusBar.setForeground(component2);
            }
        }
    }

    private static void decoratePanel(JPanel jPanel) {
        if (innerIconsPanel != null) {
            jPanel.remove(innerIconsPanel);
        }
        if ((innerIconsPanel = StatusBar.getStatusLineElements(jPanel)) != null) {
            jPanel.add((Component)innerIconsPanel, "East");
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintChildren(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = this.getWidth() - 1;
        graphics2D.setColor(TOPLINE);
        graphics2D.drawLine(0, 0, n, 0);
        graphics2D.setPaint(new GradientPaint(0.0f, 1.0f, TOP_67, 0.0f, 7.0f, TOP_60));
        graphics2D.fillRect(0, 1, this.getWidth(), 7);
        graphics2D.setPaint(new GradientPaint(0.0f, 8.0f, MIDDLE_47, 0.0f, 20.0f, MIDDLE_60));
        graphics2D.fillRect(0, 8, this.getWidth(), 12);
        if (this.dragImage == null) {
            this.dragImage = this.createDragButton(graphics2D);
        }
        graphics2D.drawImage((Image)this.dragImage, this.getWidth() - 11, this.getHeight() - 11, null);
    }

    protected BufferedImage createDragButton(Graphics2D graphics2D) {
        BufferedImage bufferedImage = graphics2D.getDeviceConfiguration().createCompatibleImage(11, 11, 2);
        graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(DRAG_LIGHT);
        graphics2D.drawRect(9, 9, 1, 1);
        graphics2D.drawRect(5, 9, 1, 1);
        graphics2D.drawRect(1, 9, 1, 1);
        graphics2D.drawRect(9, 5, 1, 1);
        graphics2D.drawRect(5, 5, 1, 1);
        graphics2D.drawRect(9, 1, 1, 1);
        graphics2D.setColor(DRAG_DARK);
        graphics2D.drawRect(8, 8, 1, 1);
        graphics2D.drawRect(4, 8, 1, 1);
        graphics2D.drawRect(0, 8, 1, 1);
        graphics2D.drawRect(8, 4, 1, 1);
        graphics2D.drawRect(4, 4, 1, 1);
        graphics2D.drawRect(8, 0, 1, 1);
        return bufferedImage;
    }

    protected BufferedImage createBar(Graphics2D graphics2D) {
        BufferedImage bufferedImage = graphics2D.getDeviceConfiguration().createCompatibleImage(2, 20);
        graphics2D = bufferedImage.createGraphics();
        graphics2D.setPaint(new LinearGradientPaint(0.0f, 0.0f, 0.0f, 19.0f, new float[]{0.0f, 0.55f, 1.0f}, new Color[]{GRAY_76, GRAY_17, GRAY_72}));
        graphics2D.drawLine(0, 0, 0, 19);
        graphics2D.setPaint(new LinearGradientPaint(1.0f, 0.0f, 1.0f, 19.0f, new float[]{0.0f, 0.55f, 1.0f}, new Color[]{Color.BLACK, GRAY_124, GRAY_13}));
        graphics2D.drawLine(1, 0, 1, 19);
        return bufferedImage;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        Font font = UIManager.getFont("controlFont");
        if (font == null) {
            font = UIManager.getFont("Tree.font");
        }
        if (font != null) {
            this.setFont(font);
        }
    }

    private class Updater
    implements ActionListener {
        private Object token;
        private long startTime;
        private Timer controller;

        public Updater(Object object) {
            this.token = object;
        }

        public void schedule() {
            this.controller = new Timer(SURVIVING_TIME, this);
            this.controller.setDelay(100);
            this.controller.start();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (StatusBar.this.clearing == this.token) {
                long l = System.currentTimeMillis();
                if (this.startTime != 0L) {
                    Color color = Color.WHITE;
                    if (color != null) {
                        int n = 256 * (int)(l - this.startTime) / 2000;
                        Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 255 - Math.min(255, n));
                        StatusBar.this.displayer.setForeground(color2);
                    }
                } else {
                    this.startTime = l;
                }
                if (l > this.startTime + 2000L) {
                    this.controller.stop();
                }
            } else {
                this.controller.stop();
            }
        }
    }

    private static class StatusLineElementsListener
    implements LookupListener {
        private JPanel decoratingPanel;

        StatusLineElementsListener(JPanel jPanel) {
            this.decoratingPanel = jPanel;
        }

        public void resultChanged(LookupEvent lookupEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StatusBar.decoratePanel(StatusLineElementsListener.this.decoratingPanel);
                }
            });
        }
    }
}

