/*
 * Decompiled with CFR 0.152.
 */
package org.officelaf.ribbon;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LinearGradientPaint;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorConvertOp;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.PanelUI;
import org.officelaf.ribbon.OfficeCommandButtonPanelUI;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.CommandButtonLayoutManager;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButtonPanel;
import org.pushingpixels.flamingo.api.common.JCommandMenuButton;
import org.pushingpixels.flamingo.api.common.RolloverActionListener;
import org.pushingpixels.flamingo.api.common.icon.FilteredResizableIcon;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenu;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenuEntryFooter;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenuEntryPrimary;
import org.pushingpixels.flamingo.internal.ui.ribbon.appmenu.CommandButtonLayoutManagerMenuTileLevel1;
import org.pushingpixels.flamingo.internal.ui.ribbon.appmenu.JRibbonApplicationMenuButton;
import org.pushingpixels.flamingo.internal.ui.ribbon.appmenu.JRibbonApplicationMenuPopupPanelSecondary;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;

public class OfficeRibbonApplicationMenuPopupPanel
extends JPopupPanel {
    private static final Color BORDER_COLOR = new Color(4407873);
    private static final Color BORDER_HIGHLIGHT1_COLOR = new Color(0x6D6C6C);
    private static final Color BORDER_HIGHLIGHT2_COLOR = new Color(7040113);
    private static final Color FOOTER_GRADIENT_1 = new Color(4408914);
    private static final Color FOOTER_GRADIENT_2 = new Color(3882564);
    private static final Color FOOTER_GRADIENT_3 = new Color(0x2F2F2F);
    private static final Color FOOTER_GRADIENT_4 = new Color(0x404040);
    private static final Color FOOTER_HIGHLIGHT = new Color(0x4A4A4A);
    private static final Color TOP_HIGHLIGHT_GRADIENT_1 = new Color(0x636262);
    private static final Color TOP_HIGHLIGHT_GRADIENT_2 = new Color(0x676667);
    private static final Color MAIN_FILL = new Color(0x5A595A);
    private static final Color[] GRADIENTS = new Color[]{FOOTER_GRADIENT_1, FOOTER_GRADIENT_2, FOOTER_GRADIENT_3, FOOTER_GRADIENT_4};
    protected JCommandButtonPanel panelLevel1;
    protected JPanel panelLevel2;
    protected JPanel footerPanel;
    protected RibbonApplicationMenuEntryPrimary.PrimaryRolloverCallback defaultPrimaryCallback;
    protected static final CommandButtonDisplayState MENU_TILE_LEVEL_1 = new CommandButtonDisplayState("Ribbon application menu tile level 1", 32){

        public CommandButtonLayoutManager createLayoutManager(AbstractCommandButton abstractCommandButton) {
            return new CommandButtonLayoutManagerMenuTileLevel1();
        }
    };

    public OfficeRibbonApplicationMenuPopupPanel(final JRibbonApplicationMenuButton jRibbonApplicationMenuButton, RibbonApplicationMenu ribbonApplicationMenu) {
        RibbonApplicationMenuEntryPrimary.PrimaryRolloverCallback primaryRolloverCallback;
        Object object3;
        Object object2;
        this.setLayout(new BorderLayout());
        this.setBorder(new LineBorder(BORDER_COLOR, BORDER_HIGHLIGHT1_COLOR, new Insets(14, 2, 0, 2)){

            @Override
            public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                super.paintBorder(component, graphics, n, n2, n3, n4);
                JRibbonApplicationMenuButton jRibbonApplicationMenuButton2 = new JRibbonApplicationMenuButton(jRibbonApplicationMenuButton.getRibbon());
                jRibbonApplicationMenuButton2.setIcon(jRibbonApplicationMenuButton.getIcon());
                jRibbonApplicationMenuButton2.getPopupModel().setRollover(false);
                jRibbonApplicationMenuButton2.getPopupModel().setPressed(true);
                jRibbonApplicationMenuButton2.getPopupModel().setArmed(true);
                jRibbonApplicationMenuButton2.getPopupModel().setPopupShowing(true);
                CellRendererPane cellRendererPane = new CellRendererPane();
                Point point = jRibbonApplicationMenuButton.getLocationOnScreen();
                Point point2 = component.getLocationOnScreen();
                cellRendererPane.setBounds(point2.x - point.x, point2.y - point.y, jRibbonApplicationMenuButton.getWidth(), jRibbonApplicationMenuButton.getHeight());
                cellRendererPane.paintComponent(graphics, (Component)jRibbonApplicationMenuButton2, (Container)component, -point2.x + point.x, -point2.y + point.y, jRibbonApplicationMenuButton.getWidth(), jRibbonApplicationMenuButton.getHeight(), true);
            }
        });
        this.defaultPrimaryCallback = new RibbonApplicationMenuEntryPrimary.PrimaryRolloverCallback(){

            public void menuEntryActivated(JPanel jPanel) {
                jPanel.removeAll();
                jPanel.revalidate();
                jPanel.repaint();
            }
        };
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new LineBorder(BORDER_HIGHLIGHT2_COLOR, BORDER_COLOR));
        this.panelLevel1 = new JCommandButtonPanel(MENU_TILE_LEVEL_1);
        this.panelLevel1.setUI((PanelUI)((Object)new OfficeCommandButtonPanelUI(){

            @Override
            protected Insets getGroupInsets() {
                return new Insets(0, 0, 0, 0);
            }

            protected int getLayoutGap() {
                return 0;
            }
        }));
        this.panelLevel1.setBackground(new Color(250, 250, 250));
        this.panelLevel1.setMaxButtonColumns(1);
        this.panelLevel1.setBorder(BorderFactory.createEmptyBorder());
        this.panelLevel1.addButtonGroup("main");
        this.panelLevel1.setToShowGroupLabels(false);
        if (ribbonApplicationMenu != null && (object2 = ribbonApplicationMenu.getPrimaryEntries()) != null && object2.size() > 0) {
            for (Object object3 : (List)object2.get(0)) {
                final JCommandMenuButton jCommandMenuButton = new JCommandMenuButton(object3.getText(), object3.getIcon());
                jCommandMenuButton.setCommandButtonKind(object3.getEntryKind());
                jCommandMenuButton.addActionListener(object3.getMainActionListener());
                if (object3.getSecondaryGroupCount() == 0) {
                    jCommandMenuButton.addRolloverActionListener(new RolloverActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            OfficeRibbonApplicationMenuPopupPanel.this.defaultPrimaryCallback.menuEntryActivated(OfficeRibbonApplicationMenuPopupPanel.this.panelLevel2);
                        }
                    });
                } else {
                    primaryRolloverCallback = new RibbonApplicationMenuEntryPrimary.PrimaryRolloverCallback((RibbonApplicationMenuEntryPrimary)object3, jCommandMenuButton){
                        final /* synthetic */ RibbonApplicationMenuEntryPrimary val$menuEntry;
                        final /* synthetic */ JCommandMenuButton val$commandButton;
                        {
                            this.val$menuEntry = ribbonApplicationMenuEntryPrimary;
                            this.val$commandButton = jCommandMenuButton;
                        }

                        public void menuEntryActivated(JPanel jPanel) {
                            jPanel.removeAll();
                            jPanel.setLayout(new BorderLayout());
                            JRibbonApplicationMenuPopupPanelSecondary jRibbonApplicationMenuPopupPanelSecondary = new JRibbonApplicationMenuPopupPanelSecondary(this.val$menuEntry){

                                public void removeNotify() {
                                    super.removeNotify();
                                    val$commandButton.getPopupModel().setPopupShowing(false);
                                }
                            };
                            JScrollPane jScrollPane = new JScrollPane((Component)jRibbonApplicationMenuPopupPanelSecondary, 20, 31);
                            Dimension dimension = jRibbonApplicationMenuPopupPanelSecondary.getPreferredSize();
                            jRibbonApplicationMenuPopupPanelSecondary.setPreferredSize(new Dimension(jPanel.getPreferredSize().width - jScrollPane.getVerticalScrollBar().getPreferredSize().width, dimension.height));
                            jPanel.add((Component)jScrollPane, "Center");
                            jPanel.revalidate();
                        }
                    };
                    jCommandMenuButton.addRolloverActionListener(new RolloverActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            primaryRolloverCallback.menuEntryActivated(OfficeRibbonApplicationMenuPopupPanel.this.panelLevel2);
                            jCommandMenuButton.getPopupModel().setPopupShowing(true);
                        }
                    });
                }
                jCommandMenuButton.setDisplayState(MENU_TILE_LEVEL_1);
                jCommandMenuButton.setHorizontalAlignment(10);
                jCommandMenuButton.setPopupOrientationKind(JCommandButton.CommandButtonPopupOrientationKind.SIDEWARD);
                jCommandMenuButton.setEnabled(object3.isEnabled());
                this.panelLevel1.addButtonToLastGroup((AbstractCommandButton)jCommandMenuButton);
            }
        }
        jPanel.add((Component)this.panelLevel1, "West");
        this.panelLevel2 = new JPanel();
        this.panelLevel2.setBorder(new Border(){

            @Override
            public Insets getBorderInsets(Component component) {
                return new Insets(0, 1, 0, 0);
            }

            @Override
            public boolean isBorderOpaque() {
                return true;
            }

            @Override
            public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                graphics.setColor(new Color(197, 197, 197));
                graphics.drawLine(n, n2, n, n2 + n4);
            }
        });
        this.panelLevel2.setPreferredSize(new Dimension(30 * FlamingoUtilities.getFont((Component)this.panelLevel1, (String[])new String[]{"Ribbon.font", "Button.font", "Panel.font"}).getSize() - 30, 10));
        jPanel.add((Component)this.panelLevel2, "Center");
        this.add(jPanel, "Center");
        object2 = new GridBagLayout();
        this.footerPanel = new JPanel((LayoutManager)object2){

            @Override
            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setPaint(new LinearGradientPaint(0.0f, 0.0f, 0.0f, this.getHeight() - 3, new float[]{0.0f, 0.45f, 0.46f, 1.0f}, GRADIENTS));
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight() - 2);
                graphics2D.setColor(FOOTER_HIGHLIGHT);
                graphics2D.fillRect(0, this.getHeight() - 2, this.getWidth(), 2);
            }
        };
        this.footerPanel.setBorder(new EmptyBorder(2, 0, 1, 1));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        object3 = new Insets(0, 6, 0, 0);
        gridBagConstraints.weightx = 1.0;
        this.footerPanel.add((Component)new JLabel(" "), gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        if (ribbonApplicationMenu != null) {
            for (int i = 0; i < ribbonApplicationMenu.getFooterEntries().size(); ++i) {
                primaryRolloverCallback = (RibbonApplicationMenuEntryFooter)ribbonApplicationMenu.getFooterEntries().get(i);
                JCommandButton jCommandButton = new JCommandButton(primaryRolloverCallback.getText(), primaryRolloverCallback.getIcon());
                jCommandButton.setDisabledIcon((ResizableIcon)new FilteredResizableIcon(primaryRolloverCallback.getIcon(), (BufferedImageOp)new ColorConvertOp(ColorSpace.getInstance(1003), null)));
                jCommandButton.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                jCommandButton.addActionListener(primaryRolloverCallback.getMainActionListener());
                jCommandButton.setDisplayState(CommandButtonDisplayState.MEDIUM);
                jCommandButton.setFlat(false);
                jCommandButton.setEnabled(primaryRolloverCallback.isEnabled());
                gridBagConstraints.gridx = i + 1;
                if (i > 0) {
                    gridBagConstraints.insets = object3;
                }
                this.footerPanel.add((Component)jCommandButton, gridBagConstraints);
            }
        }
        this.add(this.footerPanel, "South");
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = this.getWidth();
        int n2 = this.getHeight();
        graphics2D.setPaint(new LinearGradientPaint(0.0f, 0.0f, 0.0f, 6.0f, new float[]{0.0f, 1.0f}, new Color[]{TOP_HIGHLIGHT_GRADIENT_1, TOP_HIGHLIGHT_GRADIENT_2}));
        graphics2D.fillRect(0, 0, n, 6);
        graphics2D.setPaint(new LinearGradientPaint(0.0f, 8.0f, 0.0f, n2 - 3, new float[]{0.0f, 1.0f}, new Color[]{MAIN_FILL, FOOTER_GRADIENT_1}));
        graphics2D.fillRect(0, 6, n, n2 - 6);
    }

    protected static class LineBorder
    extends AbstractBorder {
        private Color outer;
        private Color inner;
        private Insets padding;

        public LineBorder(Color color, Color color2) {
            this(color, color2, new Insets(0, 0, 0, 0));
        }

        public LineBorder(Color color, Color color2, Insets insets) {
            this.outer = color;
            this.inner = color2;
            this.padding = insets;
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, super.getBorderInsets(component));
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.left = 2 + this.padding.left;
            insets.top = 2 + this.padding.top;
            insets.right = 2 + this.padding.right;
            insets.bottom = 2 + this.padding.bottom;
            return insets;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(this.outer);
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
            graphics.setColor(this.inner);
            graphics.drawRect(n + 1, n2 + 1, n3 - 3, n4 - 3);
        }
    }
}

