/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.importexport.wizard.im;

import com.paterva.maltego.archive.mtz.MaltegoArchiveReader;
import com.paterva.maltego.importexport.Config;
import com.paterva.maltego.importexport.ConfigComparator;
import com.paterva.maltego.importexport.ConfigImporter;
import com.paterva.maltego.importexport.nodes.AllConfigsNode;
import com.paterva.maltego.util.ui.PasswordUtil;
import com.paterva.maltego.util.ui.dialog.FileController;
import java.io.File;
import java.util.TreeMap;
import javax.swing.JComponent;
import net.lingala.zip4j.core.ZipFile;
import org.openide.WizardValidationException;

class ImportFileController<TData>
extends FileController {
    public ImportFileController() {
        super(0, "Maltego Archive", new String[]{"mtz", "mtgx"});
    }

    public void validate() throws WizardValidationException {
        String string = null;
        File file = this.getSelectedFile();
        if (file == null) {
            string = "Please choose a file name";
        } else {
            MaltegoArchiveReader maltegoArchiveReader = null;
            try {
                ConfigImporter[] configImporterArray;
                ZipFile zipFile = new ZipFile(file);
                if (zipFile.isEncrypted()) {
                    configImporterArray = PasswordUtil.getPasswordInput((boolean)false);
                    if (configImporterArray != null) {
                        zipFile.setPassword((String)configImporterArray);
                        if (!PasswordUtil.isPasswordValid((ZipFile)zipFile)) {
                            string = "Unable to open the file because the password was entered incorrectly.";
                        }
                    } else {
                        string = "Password required.";
                    }
                }
                if (string == null) {
                    maltegoArchiveReader = new MaltegoArchiveReader(zipFile);
                    configImporterArray = (ConfigImporter[])this.getDescriptor().getProperty("importers");
                    TreeMap<Config, ConfigImporter> treeMap = new TreeMap<Config, ConfigImporter>(new ConfigComparator());
                    for (ConfigImporter configImporter : configImporterArray) {
                        Config config = configImporter.loadConfig(maltegoArchiveReader);
                        if (config == null) continue;
                        treeMap.put(config, configImporter);
                    }
                    this.getDescriptor().putProperty("configsMap", treeMap);
                    this.getDescriptor().putProperty("allConfigs", (Object)new AllConfigsNode(treeMap.keySet(), true));
                }
            }
            catch (Exception exception) {
                string = exception.getMessage();
            }
        }
        if (string != null) {
            throw new WizardValidationException((JComponent)this.component(), string, string);
        }
    }
}

