/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.registry.actions;

import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.entity.api.SpecAction;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.util.FastURL;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.openide.awt.HtmlBrowser;
import org.openide.util.Exceptions;

public class BrowseUrlsAction
extends SpecAction {
    public String getTypeName() {
        return "maltego.spec.action.type.browse-urls";
    }

    public boolean isEnabledFor(SpecRegistry specRegistry, MaltegoPart maltegoPart, String string) {
        return !this.generatePartURLs(maltegoPart).isEmpty();
    }

    public void perform(SpecRegistry specRegistry, MaltegoPart maltegoPart, String string) {
        List<URL> list = this.generatePartURLs(maltegoPart);
        for (URL uRL : list) {
            HtmlBrowser.URLDisplayer.getDefault().showURLExternal(uRL);
        }
    }

    private List<URL> generatePartURLs(MaltegoPart maltegoPart) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (PropertyDescriptor propertyDescriptor : maltegoPart.getProperties()) {
            Object object;
            if (FastURL.class.equals((Object)propertyDescriptor.getType())) {
                object = (FastURL)maltegoPart.getValue(propertyDescriptor);
                if (object == null) continue;
                try {
                    arrayList.add(object.getURL());
                }
                catch (MalformedURLException malformedURLException) {
                    Exceptions.printStackTrace((Throwable)malformedURLException);
                }
                continue;
            }
            if (!String.class.equals((Object)propertyDescriptor.getType()) || (object = (String)maltegoPart.getValue(propertyDescriptor)) == null) continue;
            if (((String)object).startsWith("www.")) {
                object = "http://" + (String)object;
            }
            try {
                URL uRL = new URL((String)object);
                arrayList.add(uRL);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return arrayList;
    }
}

