/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.registry.converter;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.EntityConverter;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.EntityStringConverter;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.entity.registry.converter.MatchingOrderComparator;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.typing.descriptor.TypeInstantiationException;
import com.paterva.maltego.util.StringUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class DefaultEntityStringConverter
implements EntityStringConverter {
    public String convert(Collection<MaltegoEntity> collection) {
        StringBuffer stringBuffer = new StringBuffer();
        for (MaltegoEntity maltegoEntity : collection) {
            stringBuffer.append(this.convert(maltegoEntity));
            stringBuffer.append(StringUtilities.newLine());
        }
        return stringBuffer.toString();
    }

    public String convert(MaltegoEntity maltegoEntity) {
        String string = "";
        EntityRegistry entityRegistry = EntityRegistry.getDefault();
        Object object = InheritanceHelper.getValue((SpecRegistry)entityRegistry, (TypedPropertyBag)maltegoEntity);
        if (object != null) {
            string = maltegoEntity.getTypeName() + "#" + object.toString();
        }
        return string;
    }

    public Collection<MaltegoEntity> convert(String string) {
        EntityRegistry entityRegistry = (EntityRegistry)Lookup.getDefault().lookup(EntityRegistry.class);
        assert (entityRegistry != null);
        MaltegoEntitySpec[] maltegoEntitySpecArray = this.getSpecList(entityRegistry);
        ArrayList<MaltegoEntity> arrayList = new ArrayList<MaltegoEntity>();
        if (string != null) {
            String[] stringArray;
            string = string.trim();
            for (String string2 : stringArray = string.split("\r|\n|\r\n|\t")) {
                MaltegoEntity maltegoEntity;
                if ((string2 = string2.trim()).isEmpty() || (maltegoEntity = this.convertOneImpl(string2, entityRegistry, maltegoEntitySpecArray)) == null) continue;
                arrayList.add(maltegoEntity);
            }
        }
        return arrayList;
    }

    public MaltegoEntity convertOne(String string) {
        EntityRegistry entityRegistry = (EntityRegistry)Lookup.getDefault().lookup(EntityRegistry.class);
        assert (entityRegistry != null);
        MaltegoEntity maltegoEntity = this.convertOneImpl(string, entityRegistry, this.getSpecList(entityRegistry));
        return maltegoEntity;
    }

    private MaltegoEntity convertOneImpl(String string, EntityRegistry entityRegistry, MaltegoEntitySpec[] maltegoEntitySpecArray) {
        String string2;
        int n = string.indexOf(35);
        MaltegoEntitySpec maltegoEntitySpec = null;
        MaltegoEntity maltegoEntity = null;
        if (n > 0 && (maltegoEntitySpec = (MaltegoEntitySpec)entityRegistry.get(string2 = string.substring(0, n))) != null) {
            string = string.substring(n + 1);
        }
        if (maltegoEntitySpec == null) {
            maltegoEntitySpec = this.findMatch(string, maltegoEntitySpecArray);
        }
        if (maltegoEntitySpec != null) {
            maltegoEntity = this.createEntity(maltegoEntitySpec, string);
        }
        return maltegoEntity;
    }

    private MaltegoEntity createEntity(MaltegoEntitySpec maltegoEntitySpec, String string) {
        MaltegoEntity maltegoEntity = null;
        EntityFactory entityFactory = (EntityFactory)Lookup.getDefault().lookup(EntityFactory.class);
        try {
            maltegoEntity = entityFactory.createInstance(maltegoEntitySpec, false);
        }
        catch (TypeInstantiationException typeInstantiationException) {
            Exceptions.printStackTrace((Throwable)typeInstantiationException);
        }
        EntityRegistry entityRegistry = EntityRegistry.getDefault();
        PropertyDescriptor propertyDescriptor = InheritanceHelper.getValueProperty((SpecRegistry)entityRegistry, (TypedPropertyBag)maltegoEntity);
        EntityConverter entityConverter = InheritanceHelper.getConverter((EntityRegistry)entityRegistry, (MaltegoEntity)maltegoEntity, (String)string, (PropertyDescriptor)propertyDescriptor);
        if (entityConverter != null) {
            maltegoEntity = entityConverter.convertFrom((Object)string, maltegoEntity, propertyDescriptor);
        } else {
            maltegoEntity.setValue(propertyDescriptor, (Object)string);
        }
        return maltegoEntity;
    }

    private MaltegoEntitySpec[] getSpecList(EntityRegistry entityRegistry) {
        Collection collection = entityRegistry.getAll();
        MaltegoEntitySpec[] maltegoEntitySpecArray = collection.toArray(new MaltegoEntitySpec[collection.size()]);
        Arrays.sort(maltegoEntitySpecArray, new MatchingOrderComparator());
        return maltegoEntitySpecArray;
    }

    private MaltegoEntitySpec findMatch(String string, MaltegoEntitySpec[] maltegoEntitySpecArray) {
        for (MaltegoEntitySpec maltegoEntitySpec : maltegoEntitySpecArray) {
            EntityConverter entityConverter = maltegoEntitySpec.getConverter();
            if (entityConverter == null || !entityConverter.canConvertFrom((Object)string, (PropertyDescriptor)maltegoEntitySpec.getValueProperty())) continue;
            return maltegoEntitySpec;
        }
        return null;
    }
}

