/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.io.actions;

import com.paterva.maltego.ui.graph.GraphCookie;
import com.paterva.maltego.ui.graph.GraphViewCookie;
import com.paterva.maltego.ui.graph.actions.NewGraphAction;
import com.paterva.maltego.ui.graph.view2d.layout.MaltegoLayouter;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.openide.filesystems.FileLock;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.windows.TopComponent;
import yguard.A.A.D;
import yguard.A.G.l;
import yguard.A.I.BA;
import yguard.A.I.S;

public class TabularGraphOpenAction
extends NewGraphAction {
    private D _graph = null;
    private String _name = null;

    public void setGraph(D d, String string) {
        this._graph = d;
        this._name = string;
    }

    public void performAction() {
        if (this._graph == null) {
            throw new IllegalStateException("Graph not set.");
        }
        super.performAction();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TabularGraphOpenAction.this.RelayoutNewGraph();
                TabularGraphOpenAction.this.graphModifiedHack();
            }
        });
        this._graph = null;
        this._name = null;
    }

    protected DataObject getDataObject() throws DataObjectNotFoundException, IOException {
        DataObject dataObject = super.getDataObject();
        GraphCookie graphCookie = (GraphCookie)dataObject.getCookie(GraphCookie.class);
        graphCookie.setGraph(this._graph);
        this.renameDataObject(dataObject);
        dataObject.setModified(true);
        return dataObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renameDataObject(DataObject dataObject) throws IOException {
        FileLock fileLock = dataObject.getPrimaryFile().lock();
        try {
            dataObject.getPrimaryFile().rename(fileLock, this._name, dataObject.getPrimaryFile().getExt());
        }
        finally {
            fileLock.releaseLock();
        }
    }

    private void RelayoutNewGraph() {
        new BA(7).doLayout(this.getTopGraph2DView(), (l)new MaltegoLayouter());
    }

    private S getTopGraph2DView() {
        JComponent jComponent;
        GraphViewCookie graphViewCookie;
        S s = null;
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (topComponent != null && (graphViewCookie = (GraphViewCookie)topComponent.getLookup().lookup(GraphViewCookie.class)) != null && (jComponent = graphViewCookie.getGraphView().getViewControl()) instanceof S) {
            s = (S)jComponent;
        }
        return s;
    }

    private void graphModifiedHack() {
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (topComponent != null) {
            topComponent.setDisplayName(topComponent.getDisplayName() + " *");
        }
    }
}

