/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.io.wizard;

import com.paterva.maltego.graph.table.io.api.TabularGraphEntity;
import com.paterva.maltego.graph.table.io.impl.TabularGraphUtils;
import com.paterva.maltego.graph.table.io.wizard.SampleHeader;
import com.paterva.maltego.graph.table.io.wizard.SampleTableModel;
import com.paterva.maltego.typing.PropertyDescriptor;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.util.List;
import javax.swing.JTable;
import org.openide.util.ImageUtilities;

public class EntitySampleTableModel
extends SampleTableModel {
    @Override
    protected Object getHeaderValue(int n) {
        TabularGraphEntity tabularGraphEntity = TabularGraphUtils.getEntity(this.getTabularGraph(), n);
        String string = this.getTabularGraph().getColumnNames()[n];
        Object object = null;
        if (tabularGraphEntity != null) {
            int n2 = this.getTabularGraph().getEntities().indexOf(tabularGraphEntity) + 1;
            PropertyDescriptor propertyDescriptor = tabularGraphEntity.getProperty(n);
            Image image = tabularGraphEntity.getEntitySpec().getIcon(32);
            String string2 = this.createHTMLHeader(string, propertyDescriptor != null ? propertyDescriptor.getDisplayName() : "");
            object = new SampleHeader(ImageUtilities.image2Icon((Image)image), string2, n2);
        } else {
            object = this.createHTMLHeader(string, "Unmapped");
        }
        return object;
    }

    @Override
    protected void onColumnSelected(int n) {
        JTable jTable;
        TabularGraphEntity tabularGraphEntity = TabularGraphUtils.getEntity(this.getTabularGraph(), n);
        if (tabularGraphEntity != null && (jTable = this.getTable()) instanceof SampleTableModel.CustomizedSelectionTable) {
            SampleTableModel.CustomizedSelectionTable customizedSelectionTable = (SampleTableModel.CustomizedSelectionTable)((Object)jTable);
            customizedSelectionTable.select(tabularGraphEntity.getColumns());
        }
    }

    @Override
    protected void onColumnToggled(int[] nArray, int n, boolean bl) {
        List<TabularGraphEntity> list = TabularGraphUtils.getEntities(this.getTabularGraph(), nArray);
        if (list.size() == 1) {
            if (bl) {
                TabularGraphEntity tabularGraphEntity = TabularGraphUtils.getEntity(this.getTabularGraph(), n);
                if (tabularGraphEntity == null) {
                    PropertyDescriptor propertyDescriptor = TabularGraphUtils.getNextUnusedProperty(list.get(0));
                    list.get(0).put(n, propertyDescriptor);
                }
            } else {
                this.getTabularGraph().remove(n);
            }
            this.updateTableHeaders();
        }
    }

    @Override
    protected void onTabularGraphChanged(PropertyChangeEvent propertyChangeEvent) {
        super.onTabularGraphChanged(propertyChangeEvent);
        if (this.isUpdatingTabularGraph()) {
            return;
        }
        if ("entityAdded".equals(propertyChangeEvent.getPropertyName()) || "entityRemoved".equals(propertyChangeEvent.getPropertyName()) || "entityUpdated".equals(propertyChangeEvent.getPropertyName()) || "columnNamesChanged".equals(propertyChangeEvent.getPropertyName())) {
            this.updateTableHeaders();
        }
    }
}

