/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.editor.util.FlyOffsetGapList;
import org.netbeans.lib.lexer.EmbeddedJoinInfo;
import org.netbeans.lib.lexer.EmbeddingContainer;
import org.netbeans.lib.lexer.JoinTokenList;
import org.netbeans.lib.lexer.LAState;
import org.netbeans.lib.lexer.LexerInputOperation;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.TextLexerInputOperation;
import org.netbeans.lib.lexer.TokenHierarchyOperation;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.TokenListList;
import org.netbeans.lib.lexer.TokenOrEmbedding;
import org.netbeans.lib.lexer.inc.MutableTokenList;
import org.netbeans.lib.lexer.inc.TokenHierarchyEventInfo;
import org.netbeans.lib.lexer.inc.TokenListChange;
import org.netbeans.lib.lexer.token.AbstractToken;
import org.netbeans.lib.lexer.token.JoinToken;
import org.netbeans.lib.lexer.token.PartToken;
import org.netbeans.lib.lexer.token.TextToken;
import org.netbeans.spi.lexer.LanguageEmbedding;

public final class EmbeddedTokenList<T extends TokenId>
extends FlyOffsetGapList<TokenOrEmbedding<T>>
implements MutableTokenList<T> {
    public static final EmbeddedTokenList<TokenId> NO_DEFAULT_EMBEDDING = new EmbeddedTokenList(null, null, null);
    private EmbeddingContainer<?> embeddingContainer;
    private final LanguageEmbedding<T> embedding;
    private final LanguagePath languagePath;
    private LAState laState;
    private EmbeddedTokenList<?> nextEmbeddedTokenList;
    public EmbeddedJoinInfo joinInfo;
    private int extraModCount;

    public EmbeddedTokenList(EmbeddingContainer<?> embeddingContainer, LanguagePath languagePath, LanguageEmbedding<T> embedding) {
        super(1);
        this.embeddingContainer = embeddingContainer;
        this.languagePath = languagePath;
        this.embedding = embedding;
        if (embeddingContainer != null) {
            this.initLAState();
        }
    }

    public void initAllTokens() {
        assert (!this.embedding.joinSections()) : "Cannot init all tokens since ETL joins sections\n" + this + '\n' + this.dumpRelatedTLL();
        LexerInputOperation<T> lexerInputOperation = this.createLexerInputOperation(0, this.startOffset(), null);
        AbstractToken<T> token = lexerInputOperation.nextToken();
        while (token != null) {
            this.addToken(token, lexerInputOperation);
            token = lexerInputOperation.nextToken();
        }
        lexerInputOperation.release();
        lexerInputOperation = null;
        this.trimStorageToSize();
    }

    private void initLAState() {
        this.laState = this.modCount() != -1 || TokenList.LOG.isLoggable(Level.FINE) ? LAState.empty() : null;
    }

    public JoinTokenList<T> joinTokenList() {
        if (this.joinInfo != null) {
            TokenListList tokenListList = this.rootTokenList().tokenHierarchyOperation().existingTokenListList(this.languagePath);
            int etlIndex = tokenListList.findIndex(this.startOffset());
            int tokenListStartIndex = etlIndex - this.joinInfo.tokenListIndex();
            JoinTokenList jtl = new JoinTokenList(tokenListList, this.joinInfo.base, tokenListStartIndex);
            jtl.setActiveTokenListIndex(etlIndex - tokenListStartIndex);
            return jtl;
        }
        return null;
    }

    public void addToken(AbstractToken<T> token) {
        if (!token.isFlyweight()) {
            token.setTokenList(this);
        }
        this.updateElementOffsetAdd(token);
        this.add(token);
    }

    public void addToken(AbstractToken<T> token, LexerInputOperation<T> lexerInputOperation) {
        this.addToken(token);
        if (this.laState != null) {
            this.laState = this.laState.add(lexerInputOperation.lookahead(), lexerInputOperation.lexerState());
        }
    }

    public void addToken(AbstractToken<T> token, int lookahead, Object state) {
        this.addToken(token);
        if (this.laState != null) {
            this.laState = this.laState.add(lookahead, state);
        }
    }

    public void trimStorageToSize() {
        this.trimToSize();
        if (this.laState != null) {
            this.laState.trimToSize();
        }
    }

    public EmbeddedTokenList<?> nextEmbeddedTokenList() {
        return this.nextEmbeddedTokenList;
    }

    void setNextEmbeddedTokenList(EmbeddedTokenList<?> nextEmbeddedTokenList) {
        this.nextEmbeddedTokenList = nextEmbeddedTokenList;
    }

    @Override
    public LanguagePath languagePath() {
        return this.languagePath;
    }

    public LanguageEmbedding embedding() {
        return this.embedding;
    }

    @Override
    public int tokenCount() {
        return this.tokenCountCurrent();
    }

    @Override
    public int tokenCountCurrent() {
        return this.size();
    }

    public int joinTokenCount() {
        int tokenCount = this.tokenCountCurrent();
        if (tokenCount > 0 && this.joinInfo.joinTokenLastPartShift() > 0) {
            --tokenCount;
        }
        return tokenCount;
    }

    public boolean joinBackward() {
        if (this.tokenCountCurrent() > 0) {
            AbstractToken<T> token = this.tokenOrEmbeddingUnsync(0).token();
            return token.getClass() == PartToken.class && ((PartToken)token).partTokenIndex() > 0;
        }
        return this.joinInfo.joinTokenLastPartShift() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TokenOrEmbedding<T> tokenOrEmbedding(int index) {
        TokenList<?> tokenList = this.rootTokenList();
        synchronized (tokenList) {
            return index < this.size() ? (TokenOrEmbedding)this.get(index) : null;
        }
    }

    @Override
    public int lookahead(int index) {
        return this.laState != null ? this.laState.lookahead(index) : -1;
    }

    @Override
    public Object state(int index) {
        return this.laState != null ? this.laState.state(index) : null;
    }

    @Override
    public int tokenOffset(int index) {
        return this.elementOffset(index);
    }

    @Override
    public int tokenOffset(AbstractToken<T> token) {
        if (token.getClass() == JoinToken.class) {
            return token.offset(null);
        }
        int rawOffset = token.rawOffset();
        int relOffset = rawOffset < this.offsetGapStart() ? rawOffset : rawOffset - this.offsetGapLength();
        return this.startOffset() + relOffset;
    }

    @Override
    public int[] tokenIndex(int offset) {
        return LexerUtilsConstants.tokenIndexBinSearch(this, offset, this.tokenCountCurrent());
    }

    @Override
    public int modCount() {
        return this.embeddingContainer.cachedModCount() + this.extraModCount;
    }

    void resetExtraModCount() {
        this.extraModCount = 0;
    }

    @Override
    public int startOffset() {
        return this.embeddingContainer.branchTokenStartOffset() + this.embedding.startSkipLength();
    }

    @Override
    public int endOffset() {
        return this.embeddingContainer.branchTokenStartOffset() + this.embeddingContainer.token().length() - this.embedding.endSkipLength();
    }

    public int textLength() {
        return this.embeddingContainer.token().length() - this.embedding.startSkipLength() - this.embedding.endSkipLength();
    }

    @Override
    public boolean isRemoved() {
        return this.embeddingContainer.isRemoved();
    }

    @Override
    public TokenList<?> rootTokenList() {
        return this.embeddingContainer.rootTokenList();
    }

    @Override
    public CharSequence inputSourceText() {
        return this.rootTokenList().inputSourceText();
    }

    @Override
    public TokenHierarchyOperation<?, ?> tokenHierarchyOperation() {
        return this.rootTokenList().tokenHierarchyOperation();
    }

    protected int elementRawOffset(TokenOrEmbedding<T> elem) {
        return elem.token().rawOffset();
    }

    protected void setElementRawOffset(TokenOrEmbedding<T> elem, int rawOffset) {
        elem.token().setRawOffset(rawOffset);
    }

    protected boolean isElementFlyweight(TokenOrEmbedding<T> elem) {
        return elem.token().isFlyweight();
    }

    protected int elementLength(TokenOrEmbedding<T> elem) {
        return elem.token().length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractToken<T> replaceFlyToken(int index, AbstractToken<T> flyToken, int offset) {
        TokenList<?> tokenList = this.rootTokenList();
        synchronized (tokenList) {
            TextToken nonFlyToken = ((TextToken)flyToken).createCopy(this, this.offset2Raw(offset));
            this.set(index, nonFlyToken);
            return nonFlyToken;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wrapToken(int index, EmbeddingContainer<T> embeddingContainer) {
        TokenList<?> tokenList = this.rootTokenList();
        synchronized (tokenList) {
            this.set(index, embeddingContainer);
        }
    }

    @Override
    public InputAttributes inputAttributes() {
        return this.rootTokenList().inputAttributes();
    }

    @Override
    public TokenOrEmbedding<T> tokenOrEmbeddingUnsync(int index) {
        return (TokenOrEmbedding)this.get(index);
    }

    @Override
    public LexerInputOperation<T> createLexerInputOperation(int tokenIndex, int relexOffset, Object relexState) {
        int endOffset = this.endOffset();
        assert (relexOffset <= endOffset) : "Invalid relexOffset=" + relexOffset + " > endOffset()=" + endOffset;
        return new TextLexerInputOperation(this, tokenIndex, relexState, relexOffset, endOffset);
    }

    @Override
    public boolean isFullyLexed() {
        return true;
    }

    @Override
    public void replaceTokens(TokenListChange<T> change, TokenHierarchyEventInfo eventInfo, boolean modInside) {
        List<TokenOrEmbedding<T>> addedTokenOrEmbeddings;
        assert (this.embeddingContainer.checkStatusUpdated());
        ++this.extraModCount;
        int index = change.index();
        int removedTokenCount = change.removedTokenCount();
        AbstractToken firstRemovedToken = null;
        if (removedTokenCount > 0) {
            Object[] removedTokensOrEmbeddings = new TokenOrEmbedding[removedTokenCount];
            this.copyElements(index, index + removedTokenCount, removedTokensOrEmbeddings, 0);
            firstRemovedToken = removedTokensOrEmbeddings[0].token();
            int removedOffsetShift = 0;
            if (!this.embeddingContainer.isRemoved() && this.embeddingContainer.branchTokenStartOffset() >= eventInfo.modOffset() + eventInfo.insertedLength() && !change.parentChangeIsBoundsChange()) {
                removedOffsetShift -= eventInfo.diffLength();
            }
            for (int i = 0; i < removedTokenCount; ++i) {
                Object tokenOrEmbedding = removedTokensOrEmbeddings[i];
                AbstractToken token = tokenOrEmbedding.token();
                if (token.isFlyweight()) continue;
                this.updateElementOffsetRemove(token);
                if (removedOffsetShift != 0) {
                    token.setRawOffset(token.rawOffset() + removedOffsetShift);
                }
                token.setTokenList(null);
                EmbeddingContainer ec = tokenOrEmbedding.embedding();
                if (ec == null) continue;
                ec.markRemoved(token.rawOffset());
            }
            this.remove(index, removedTokenCount);
            this.laState.remove(index, removedTokenCount);
            change.setRemovedTokens((TokenOrEmbedding<T>[])removedTokensOrEmbeddings);
        } else {
            change.setRemovedTokensEmpty();
        }
        if (modInside) {
            int startOffset = this.startOffset();
            if (this.offsetGapStart() != change.offset() - startOffset) {
                this.moveOffsetGap(change.offset() - startOffset, change.index());
            }
            this.updateOffsetGapLength(-eventInfo.diffLength());
        }
        if ((addedTokenOrEmbeddings = change.addedTokenOrEmbeddings()) != null) {
            for (TokenOrEmbedding<T> tokenOrEmbedding : addedTokenOrEmbeddings) {
                AbstractToken<T> token = tokenOrEmbedding.token();
                if (!token.isFlyweight()) {
                    token.setTokenList(this);
                }
                this.updateElementOffsetAdd(token);
            }
            this.addAll(index, addedTokenOrEmbeddings);
            this.laState = this.laState.addAll(index, change.laState());
            change.syncAddedTokenCount();
            if (removedTokenCount == 1 && addedTokenOrEmbeddings.size() == 1) {
                AbstractToken<T> addedToken = change.addedTokenOrEmbeddings().get(0).token();
                if (firstRemovedToken.id() == addedToken.id() && firstRemovedToken.partType() == addedToken.partType()) {
                    change.markBoundsChange();
                }
            }
        }
    }

    @Override
    public boolean isContinuous() {
        return true;
    }

    @Override
    public Set<T> skipTokenIds() {
        return null;
    }

    public EmbeddingContainer<?> embeddingContainer() {
        return this.embeddingContainer;
    }

    public void setEmbeddingContainer(EmbeddingContainer<?> embeddingContainer) {
        this.embeddingContainer = embeddingContainer;
    }

    public StringBuilder dumpInfo(StringBuilder sb) {
        EmbeddingContainer<?> ec;
        if (sb == null) {
            sb = new StringBuilder(50);
        }
        if ((ec = this.embeddingContainer) != null && ec.isRemoved()) {
            sb.append("REMOVED-");
        }
        sb.append("ETL");
        if (this.embedding.joinSections()) {
            sb.append('j');
        }
        sb.append('<').append(this.startOffset());
        sb.append(",").append(this.endOffset());
        sb.append("> TC=").append(this.tokenCountCurrent());
        if (this.joinInfo != null) {
            sb.append("(").append(this.joinTokenCount()).append(')');
            sb.append(" JI:");
            this.joinInfo.dumpInfo(sb, this);
        }
        sb.append(", IHC=").append(System.identityHashCode(this));
        return sb;
    }

    private String dumpRelatedTLL() {
        TokenListList tll = this.rootTokenList().tokenHierarchyOperation().existingTokenListList(this.languagePath);
        return tll != null ? tll.toString() : "<No TokenListList for " + this.languagePath.mimePath() + ">";
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        this.dumpInfo(sb);
        LexerUtilsConstants.appendTokenList(sb, this);
        return sb.toString();
    }
}

