/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.lang.reflect.Modifier;
import org.simpleframework.xml.core.Context;
import org.simpleframework.xml.core.InstantiationException;
import org.simpleframework.xml.core.Support;
import org.simpleframework.xml.strategy.Type;
import org.simpleframework.xml.strategy.Value;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.OutputNode;

abstract class Factory {
    protected Context context;
    protected Support support;
    protected Type type;

    protected Factory(Context context, Type type) {
        this.support = context.getSupport();
        this.context = context;
        this.type = type;
    }

    public Class getType() {
        return this.type.getType();
    }

    public Object getInstance() throws Exception {
        Class type = this.getType();
        if (!Factory.isInstantiable(type)) {
            throw new InstantiationException("Type %s can not be instantiated", type);
        }
        return type.newInstance();
    }

    protected Value getOverride(InputNode node) throws Exception {
        Value value = this.getConversion(node);
        if (value != null) {
            Class type = value.getType();
            Class expect = this.getType();
            if (!Factory.isCompatible(expect, type)) {
                throw new InstantiationException("Type %s is not compatible with %s", type, expect);
            }
        }
        return value;
    }

    public boolean setOverride(Type type, Object value, OutputNode node) throws Exception {
        Class expect = type.getType();
        if (!expect.isPrimitive()) {
            return this.context.setOverride(type, value, node);
        }
        return false;
    }

    public Value getConversion(InputNode node) throws Exception {
        return this.context.getOverride(this.type, node);
    }

    public static boolean isCompatible(Class expect, Class type) {
        if (expect.isArray()) {
            expect = expect.getComponentType();
        }
        return expect.isAssignableFrom(type);
    }

    public static boolean isInstantiable(Class type) {
        int modifiers = type.getModifiers();
        if (Modifier.isAbstract(modifiers)) {
            return false;
        }
        return !Modifier.isInterface(modifiers);
    }
}

