/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;
import org.openide.util.WeakSet;

final class DeepListener
extends WeakReference<FileChangeListener>
implements FileChangeListener,
Runnable,
Callable<Boolean> {
    private static final Logger LOG = Logger.getLogger(DeepListener.class.getName());
    private final File path;
    private FileObject watching;
    private boolean removed;
    private final Callable<Boolean> stop;
    private static List<DeepListener> keep = new ArrayList<DeepListener>();
    private Set<FileEvent> delivered = Collections.synchronizedSet(new WeakSet());

    DeepListener(FileChangeListener listener, File path, Callable<Boolean> stop) {
        super(listener, Utilities.activeReferenceQueue());
        this.path = path;
        this.stop = stop;
        keep.add(this);
    }

    final void init() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, null, new Throwable("listening to " + this.path));
        }
        this.relisten();
    }

    @Override
    public void run() {
        FileObject fo = FileUtil.toFileObject(this.path);
        if (fo != null) {
            fo.removeRecursiveListener(this);
        }
        this.removed = true;
        keep.remove(this);
    }

    private synchronized void relisten() {
        FileObject fo = FileUtil.toFileObject(this.path);
        if (fo == this.watching) {
            return;
        }
        if (this.watching != null) {
            this.watching.removeRecursiveListener(this);
            this.watching = null;
        }
        if (fo != null) {
            this.watching = fo;
            fo.addRecursiveListener(this);
        }
    }

    @Override
    public void fileRenamed(FileRenameEvent fe) {
        this.fileRenamed(fe, false);
    }

    public void fileRenamed(FileRenameEvent fe, boolean fromHolder) {
        this.relisten();
        FileChangeListener listener = this.get(fe, fromHolder);
        if (listener == null) {
            return;
        }
        listener.fileRenamed(fe);
    }

    @Override
    public void fileFolderCreated(FileEvent fe) {
        this.relisten();
        this.fileFolderCreated(fe, false);
    }

    public void fileFolderCreated(FileEvent fe, boolean fromHolder) {
        this.relisten();
        FileChangeListener listener = this.get(fe, fromHolder);
        if (listener == null) {
            return;
        }
        listener.fileFolderCreated(fe);
    }

    @Override
    public void fileDeleted(FileEvent fe) {
        this.fileDeleted(fe, false);
    }

    public void fileDeleted(FileEvent fe, boolean fromHolder) {
        this.relisten();
        FileChangeListener listener = this.get(fe, fromHolder);
        if (listener == null) {
            return;
        }
        listener.fileDeleted(fe);
    }

    @Override
    public void fileDataCreated(FileEvent fe) {
        this.fileDataCreated(fe, false);
    }

    public void fileDataCreated(FileEvent fe, boolean fromHolder) {
        this.relisten();
        FileChangeListener listener = this.get(fe, fromHolder);
        if (listener == null) {
            return;
        }
        listener.fileDataCreated(fe);
    }

    @Override
    public void fileChanged(FileEvent fe) {
        this.fileChanged(fe, false);
    }

    public void fileChanged(FileEvent fe, boolean fromHolder) {
        FileChangeListener listener = this.get(fe, fromHolder);
        if (listener == null) {
            return;
        }
        listener.fileChanged(fe);
    }

    @Override
    public void fileAttributeChanged(FileAttributeEvent fe) {
        FileChangeListener listener = this.get(fe, false);
        if (listener == null) {
            return;
        }
        listener.fileAttributeChanged(fe);
    }

    public boolean equals(Object obj) {
        FileChangeListener otherListener;
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeepListener other = (DeepListener)obj;
        FileChangeListener thisListener = (FileChangeListener)this.get();
        return thisListener == (otherListener = (FileChangeListener)other.get()) || thisListener != null && thisListener.equals(otherListener);
    }

    public int hashCode() {
        FileChangeListener thisListener = (FileChangeListener)this.get();
        int hash = 7;
        hash = 11 * hash + (thisListener != null ? thisListener.hashCode() : 0);
        return hash;
    }

    private FileChangeListener get(FileEvent fe, boolean fromHolder) {
        if (this.removed) {
            return null;
        }
        if (fromHolder && fe.getFile() != fe.getSource()) {
            return null;
        }
        if (!this.delivered.add(fe)) {
            return null;
        }
        return (FileChangeListener)this.get();
    }

    @Override
    public Boolean call() throws Exception {
        return this.stop != null ? this.stop.call() : null;
    }
}

