/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.view.ball;

import com.paterva.maltego.layout.LayoutFactory;
import com.paterva.maltego.layout.view.LayoutViewAdapter;
import com.paterva.maltego.ui.graph.view2d.DetailedNodeRealizer;
import com.paterva.maltego.view.ball.BallViewOptions;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.openide.util.ImageUtilities;
import yguard.A.A.C;
import yguard.A.A.E;
import yguard.A.A.H;
import yguard.A.A.Y;
import yguard.A.A._;
import yguard.A.I.;
import yguard.A.I.QA;

public class EdgeWeightedView
extends LayoutViewAdapter
implements ActionListener {
    private static final String ACTION_SIZE_IN = "sizeIn";
    private static final String ACTION_SIZE_OUT = "sizeOut";
    private static final String ACTION_SIZE_ALL = "sizeAll";
    private Updater _updater;

    protected LayoutFactory.LayoutMode getDefaultLayoutMode() {
        return LayoutFactory.LayoutMode.INTERACTIVE_ORGANIC;
    }

    protected void onGraphChanged(QA qA, QA qA2) {
        super.onGraphChanged(qA, qA2);
        if (qA != null) {
            qA.B((_)this.updater());
        }
        if (qA2 != null) {
            qA2.A((_)this.updater());
        }
    }

    public JComponent getToolbar() {
        boolean bl = this._toolbar == null;
        JComponent jComponent = super.getToolbar();
        if (bl && jComponent instanceof JToolBar) {
            JToolBar jToolBar = (JToolBar)jComponent;
            jToolBar.addSeparator();
            ButtonGroup buttonGroup = new ButtonGroup();
            JToggleButton jToggleButton = null;
            jToggleButton = this.addToggleButton(jToolBar, buttonGroup, ACTION_SIZE_IN, "com/paterva/maltego/view/ball/SizeInLinks.png", "Use incoming links for ball size");
            jToggleButton.setSelected(BallViewOptions.getEdgesUsedForSize() == 0);
            jToggleButton = this.addToggleButton(jToolBar, buttonGroup, ACTION_SIZE_OUT, "com/paterva/maltego/view/ball/SizeOutLinks.png", "Use outgoing links for ball size");
            jToggleButton.setSelected(BallViewOptions.getEdgesUsedForSize() == 1);
            jToggleButton = this.addToggleButton(jToolBar, buttonGroup, ACTION_SIZE_ALL, "com/paterva/maltego/view/ball/SizeAllLinks.png", "Use all connected links for ball size");
            jToggleButton.setSelected(BallViewOptions.getEdgesUsedForSize() == 2);
        }
        return jComponent;
    }

    private JToggleButton addToggleButton(JToolBar jToolBar, ButtonGroup buttonGroup, String string, String string2, String string3) {
        JToggleButton jToggleButton = new JToggleButton();
        jToggleButton.setIcon(ImageUtilities.loadImageIcon((String)string2, (boolean)false));
        jToggleButton.setToolTipText(string3);
        jToggleButton.setFocusPainted(false);
        jToggleButton.setActionCommand(string);
        jToggleButton.addActionListener(this);
        buttonGroup.add(jToggleButton);
        jToolBar.add(jToggleButton);
        return jToggleButton;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        String string = actionEvent.getActionCommand();
        int n2 = BallViewOptions.getEdgesUsedForSize();
        if (n2 != (n = ACTION_SIZE_IN.equals(string) ? 0 : (ACTION_SIZE_OUT.equals(string) ? 1 : 2))) {
            this.updateNodeSizes(n);
        }
    }

    private void updateNodeSizes(int n) {
        BallViewOptions.setEdgesUsedForSize(n);
        QA qA = this.getView().H();
        qA.\u00e3();
        E e = qA.\u00d1();
        while (e.ok()) {
            .A a = qA.f(e.node());
            if (a instanceof DetailedNodeRealizer.EntiyNodeRealizer) {
                ((DetailedNodeRealizer.EntiyNodeRealizer)a).update();
            }
            e.next();
        }
        qA.\u00d0();
        this.getView().I();
    }

    private Updater updater() {
        if (this._updater == null) {
            this._updater = new Updater();
        }
        return this._updater;
    }

    private class Updater
    implements _ {
        private int _block;
        private List<Y> _changed = new LinkedList<Y>();

        private Updater() {
        }

        public void onGraphEvent(C c) {
            H h;
            switch (c.C()) {
                case 12: {
                    ++this._block;
                    break;
                }
                case 13: {
                    --this._block;
                    break;
                }
                case 1: 
                case 5: {
                    h = (H)c.A();
                    this._changed.add(h.X());
                    this._changed.add(h.V());
                    break;
                }
            }
            if (this._block == 0 && this._changed.size() > 0) {
                h = (QA)EdgeWeightedView.this.getGraph();
                for (Y y : this._changed) {
                    .A a = h.f(y);
                    if (!(a instanceof DetailedNodeRealizer.EntiyNodeRealizer)) continue;
                    DetailedNodeRealizer.EntiyNodeRealizer entiyNodeRealizer = (DetailedNodeRealizer.EntiyNodeRealizer)a;
                    entiyNodeRealizer.update();
                }
                this._changed.clear();
            }
        }
    }
}

