/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.layout;

import com.paterva.maltego.ui.graph.view2d.layout.HorizontalAlignLayouter;
import com.paterva.maltego.ui.graph.view2d.layout.MaltegoLayouter;
import com.paterva.maltego.ui.graph.view2d.layout.VerticalAlignLayouter;
import yguard.A.G.A.L;
import yguard.A.G.G.C;
import yguard.A.G.L.F;
import yguard.A.G.l;

public class LayoutFactory {
    public static String getName(LayoutMode layoutMode) {
        switch (layoutMode) {
            case BLOCK: {
                return "Block";
            }
            case HIERARCHICAL: {
                return "Hierarchical";
            }
            case CIRCULAR: {
                return "Circular";
            }
            case ORGANIC: {
                return "Organic";
            }
            case ALIGN_LEFT: {
                return "Left Align";
            }
            case ALIGN_RIGHT: {
                return "Right Align";
            }
            case ALIGN_TOP: {
                return "Top Align";
            }
            case ALIGN_BOTTOM: {
                return "Bottom Align";
            }
            case CENTER_VERTICALLY: {
                return "Center Vertically";
            }
            case CENTER_HORIZONTALLY: {
                return "Center Horizontally";
            }
            case INTERACTIVE_ORGANIC: {
                return "Interactive Organic";
            }
        }
        throw new IllegalArgumentException("Layout mode does not exist.");
    }

    public static LayoutMode getMode(String string) {
        for (LayoutMode layoutMode : LayoutMode.values()) {
            if (!LayoutFactory.getName(layoutMode).equals(string)) continue;
            return layoutMode;
        }
        return null;
    }

    public static l getLayouter(LayoutMode layoutMode) throws IllegalStateException {
        MaltegoLayouter maltegoLayouter = null;
        switch (layoutMode) {
            case BLOCK: {
                maltegoLayouter = new MaltegoLayouter();
                break;
            }
            case HIERARCHICAL: {
                maltegoLayouter = new C();
                ((C)maltegoLayouter).k(60.0);
                break;
            }
            case CIRCULAR: {
                maltegoLayouter = new F();
                break;
            }
            case ORGANIC: {
                maltegoLayouter = new yguard.A.G.A.F();
                ((yguard.A.G.A.F)maltegoLayouter).Z(50.0);
                break;
            }
            case ALIGN_LEFT: {
                maltegoLayouter = new VerticalAlignLayouter(0.0);
                break;
            }
            case ALIGN_RIGHT: {
                maltegoLayouter = new VerticalAlignLayouter(1.0);
                break;
            }
            case ALIGN_TOP: {
                maltegoLayouter = new HorizontalAlignLayouter(0.0);
                break;
            }
            case ALIGN_BOTTOM: {
                maltegoLayouter = new HorizontalAlignLayouter(1.0);
                break;
            }
            case CENTER_VERTICALLY: {
                maltegoLayouter = new VerticalAlignLayouter(0.5);
                break;
            }
            case CENTER_HORIZONTALLY: {
                maltegoLayouter = new HorizontalAlignLayouter(0.5);
                break;
            }
            case INTERACTIVE_ORGANIC: {
                L l2 = new L();
                l2.A(true);
                l2.N();
                l2.B(5000.0);
                maltegoLayouter = l2;
                break;
            }
            default: {
                throw new IllegalStateException("Layout mode invalid.");
            }
        }
        return maltegoLayouter;
    }

    public static boolean isInteractive(LayoutMode layoutMode) {
        return LayoutMode.INTERACTIVE_ORGANIC.equals((Object)layoutMode);
    }

    public static enum LayoutMode {
        BLOCK,
        HIERARCHICAL,
        CIRCULAR,
        ORGANIC,
        ALIGN_LEFT,
        ALIGN_RIGHT,
        ALIGN_TOP,
        ALIGN_BOTTOM,
        CENTER_VERTICALLY,
        CENTER_HORIZONTALLY,
        INTERACTIVE_ORGANIC;

    }
}

