/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.actions;

import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import org.openide.explorer.ExplorerManager;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public abstract class EditorAction
extends SystemAction {
    private Lookup.Result<ExplorerManager> _lookupResult;
    private ViewLookupListener _listener;
    private ExplorerManager _explorer;

    public EditorAction() {
        this.setEnabled(false);
        this._listener = new ViewLookupListener();
        GraphEditorRegistry.getDefault().addPropertyChangeListener(this._listener);
        Lookup.Template template = new Lookup.Template(ExplorerManager.class);
        this._lookupResult = Utilities.actionsGlobalContext().lookup(template);
        this._lookupResult.addLookupListener((LookupListener)this._listener);
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        TopComponent topComponent = this.getTopComponent();
        ExplorerManager explorerManager = EditorAction.find(topComponent);
        if (explorerManager != null) {
            try {
                this.performAction(explorerManager);
                topComponent.requestActive();
            }
            catch (PropertyVetoException propertyVetoException) {
                Exceptions.printStackTrace((Throwable)propertyVetoException);
            }
        }
    }

    protected TopComponent getTopComponent() {
        return GraphEditorRegistry.getDefault().getTopmost();
    }

    protected ExplorerManager getViewExplorerManager() {
        return EditorAction.find(this.getTopComponent());
    }

    protected static ExplorerManager find(TopComponent topComponent) {
        if (topComponent == null) {
            return null;
        }
        if (topComponent instanceof ExplorerManager.Provider) {
            return ((ExplorerManager.Provider)topComponent).getExplorerManager();
        }
        return (ExplorerManager)topComponent.getLookup().lookup(ExplorerManager.class);
    }

    public final boolean isEnabled() {
        return super.isEnabled();
    }

    protected boolean isEnabled(ExplorerManager explorerManager) {
        return explorerManager != null;
    }

    protected abstract void performAction(ExplorerManager var1) throws PropertyVetoException;

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    private void onExplorerChanged() {
        if (this._explorer != null) {
            this._explorer.removePropertyChangeListener((PropertyChangeListener)this._listener);
        }
        this._explorer = this.getViewExplorerManager();
        if (this._explorer != null) {
            this._explorer.addPropertyChangeListener((PropertyChangeListener)this._listener);
        }
        this.onSelectionChanged();
    }

    private void onSelectionChanged() {
        this.setEnabled(this.isEnabled(this._explorer));
    }

    private class ViewLookupListener
    implements PropertyChangeListener,
    LookupListener {
        private ViewLookupListener() {
        }

        public void resultChanged(LookupEvent lookupEvent) {
            EditorAction.this.onExplorerChanged();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("topmost".equals(propertyChangeEvent.getPropertyName())) {
                EditorAction.this.onExplorerChanged();
            } else if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
                EditorAction.this.onSelectionChanged();
            }
        }
    }
}

