/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.actions;

import com.paterva.maltego.ui.graph.actions.EditorAction;
import com.paterva.maltego.ui.graph.nodes.GraphNodeManager;
import java.beans.PropertyVetoException;
import java.util.HashSet;
import java.util.Set;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import yguard.A.A.H;
import yguard.A.A.Y;
import yguard.A.A.Z;

public abstract class SelectFamilyAction
extends EditorAction {
    public static final int PARENTS = 1;
    public static final int CHILDREN = 2;
    private boolean _keepSelection;
    private int _selectWhat;

    public SelectFamilyAction(int n, boolean bl) {
        this._selectWhat = n;
        this._keepSelection = bl;
    }

    @Override
    protected void performAction(ExplorerManager explorerManager) throws PropertyVetoException {
        HashSet<Node> hashSet = new HashSet<Node>();
        HashSet<Y> hashSet2 = new HashSet<Y>();
        HashSet<H> hashSet3 = new HashSet<H>();
        GraphNodeManager graphNodeManager = null;
        for (Node node : explorerManager.getSelectedNodes()) {
            H h;
            Y y;
            if (this._keepSelection) {
                hashSet.add(node);
            }
            if ((y = (Y)node.getLookup().lookup(Y.class)) != null) {
                if (graphNodeManager == null) {
                    graphNodeManager = GraphNodeManager.getInstance(y.H());
                }
                if ((this._selectWhat & 1) != 0) {
                    this.addParents(y, hashSet2);
                }
                if ((this._selectWhat & 2) != 0) {
                    this.addChildren(y, hashSet2);
                }
            }
            if ((h = (H)node.getLookup().lookup(H.class)) == null) continue;
            if (graphNodeManager == null) {
                graphNodeManager = GraphNodeManager.getInstance(h.a());
            }
            if (this._selectWhat == 3) {
                this.addNeighbours(h, hashSet3);
                continue;
            }
            if (this._selectWhat == 1) {
                this.addParents(h, hashSet3);
                continue;
            }
            if (this._selectWhat != 2) continue;
            this.addChildren(h, hashSet3);
        }
        Object object = hashSet2.iterator();
        while (object.hasNext()) {
            hashSet.add(graphNodeManager.getNode((Y)object.next()));
        }
        object = hashSet3.iterator();
        while (object.hasNext()) {
            hashSet.add(graphNodeManager.getNode((H)object.next()));
        }
        if (hashSet.size() > 0) {
            explorerManager.setSelectedNodes(hashSet.toArray(new Node[hashSet.size()]));
        }
    }

    private void addChildren(Y y, Set<Y> set) {
        Z z = y.G();
        while (z.ok()) {
            set.add(z.edge().V());
            z.next();
        }
    }

    private void addParents(Y y, Set<Y> set) {
        Z z = y.M();
        while (z.ok()) {
            set.add(z.edge().X());
            z.next();
        }
    }

    private void addChildren(H h, Set<H> set) {
        Y y = h.V();
        Z z = y.G();
        while (z.ok()) {
            set.add(z.edge());
            z.next();
        }
    }

    private void addParents(H h, Set<H> set) {
        Y y = h.X();
        Z z = y.M();
        while (z.ok()) {
            set.add(z.edge());
            z.next();
        }
    }

    private void addNeighbours(H h, Set<H> set) {
        Y y = h.X();
        Z z = y.G();
        while (z.ok()) {
            H h2 = z.edge();
            if (!h2.equals(h)) {
                set.add(h2);
            }
            z.next();
        }
    }

    @Override
    protected boolean isEnabled(ExplorerManager explorerManager) {
        return explorerManager != null && explorerManager.getSelectedNodes().length > 0;
    }
}

