/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.actions;

import com.paterva.maltego.ui.graph.GraphStructureUtils;
import com.paterva.maltego.ui.graph.GraphViewCookie;
import com.paterva.maltego.ui.graph.actions.SelectionMode;
import com.pinkmatter.api.flamingo.ResizableIcons;
import com.pinkmatter.api.flamingo.RibbonPresenter;
import com.pinkmatter.api.flamingo.RibbonPresenters;
import javax.swing.Action;
import javax.swing.JComponent;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.TopComponent;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import yguard.A.A.A;
import yguard.A.A.D;
import yguard.A.A.X;
import yguard.A.I.QA;
import yguard.A.I.S;

public class SelectionToggleAction
extends CallableSystemAction
implements RibbonPresenter.Button {
    private AbstractCommandButton _ribbonPresenter;
    private ResizableIcon _linkIcon;
    private ResizableIcon _entityIcon;

    public String getName() {
        return "Selection mode";
    }

    protected String iconResource() {
        return "com/paterva/maltego/ui/graph/actions/Zoom.png";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public void performAction() {
        SelectionMode.setNextMode();
        this._ribbonPresenter.setIcon(this.getResizableIcon());
        this._ribbonPresenter.setText(this.getText());
        S s = this.getTopGraph2DView();
        if (s != null) {
            QA qA = s.H();
            if (SelectionMode.isEntities()) {
                X x = GraphStructureUtils.getAttachedNodes((D)qA, qA.\u0115());
                qA.\u0111();
                qA.A(x.t(), true);
            } else {
                A a2 = GraphStructureUtils.getEdgesBetween((D)qA, qA.\u011c());
                qA.\u010b();
                qA.B(a2.q(), true);
            }
            qA.\u011b();
        }
    }

    private S getTopGraph2DView() {
        JComponent jComponent;
        GraphViewCookie graphViewCookie;
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (topComponent != null && (graphViewCookie = (GraphViewCookie)topComponent.getLookup().lookup(GraphViewCookie.class)) != null && (jComponent = graphViewCookie.getGraphView().getViewControl()) instanceof S) {
            return (S)jComponent;
        }
        return null;
    }

    private String getText() {
        if (SelectionMode.isEntities()) {
            return "Entity Selection";
        }
        if (SelectionMode.isLinks()) {
            return "Link Selection";
        }
        return "Unknown Selection";
    }

    private ResizableIcon getResizableIcon() {
        if (SelectionMode.isEntities()) {
            if (this._entityIcon == null) {
                this._entityIcon = ResizableIcons.fromResource((String)"com/paterva/maltego/ui/graph/actions/SelectionToggleEntity.png");
            }
            return this._entityIcon;
        }
        if (SelectionMode.isLinks()) {
            if (this._linkIcon == null) {
                this._linkIcon = ResizableIcons.fromResource((String)"com/paterva/maltego/ui/graph/actions/SelectionToggleLink.png");
            }
            return this._linkIcon;
        }
        return ResizableIcons.fromResource((String)this.iconResource());
    }

    public AbstractCommandButton getRibbonButtonPresenter() {
        if (this._ribbonPresenter == null) {
            this._ribbonPresenter = RibbonPresenters.createCommandButton((Action)((Object)this), (String)this.getText(), (ResizableIcon)this.getResizableIcon());
            RichTooltip richTooltip = new RichTooltip("Selection Mode", "Set the selection mode to either Entity Selection or Link Selection. (Ctrl+M)");
            richTooltip.addFooterSection("Click the help button to get more help on Maltego features");
            richTooltip.setFooterImage(ImageUtilities.loadImage((String)"com/paterva/maltego/welcome/resources/Help.png"));
            this._ribbonPresenter.setActionRichTooltip(richTooltip);
        }
        return this._ribbonPresenter;
    }
}

