/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.nodes;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.PropertyBag;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.editing.AbstractAddAttachmentsAction;
import com.paterva.maltego.typing.editing.AttachmentUtils;
import com.paterva.maltego.typing.types.Attachment;
import com.paterva.maltego.util.FastURL;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openide.nodes.Node;

public class AddAttachmentsAction
extends AbstractAddAttachmentsAction {
    public String getName() {
        return "Attach";
    }

    protected boolean enable(Node[] nodeArray) {
        return this.getActivatedEntities().size() > 0;
    }

    protected void performAction(Node[] nodeArray) {
        super.perform(this.getActivatedEntities());
    }

    public void perform(MaltegoEntity maltegoEntity) {
        ArrayList<MaltegoEntity> arrayList = new ArrayList<MaltegoEntity>(1);
        arrayList.add(maltegoEntity);
        super.perform(arrayList);
    }

    protected void attachFile(Object object, File file, FastURL fastURL) throws IOException {
        Attachment attachment = AttachmentUtils.createAttachment((File)file, (FastURL)fastURL);
        this.attach((MaltegoEntity)object, attachment);
    }

    protected void attachFile(List list, File file, FastURL fastURL) throws IOException {
        if (list != null) {
            Attachment attachment = AttachmentUtils.createAttachment((File)file, (FastURL)fastURL);
            for (Object e : list) {
                this.attach((MaltegoEntity)e, attachment);
            }
        }
    }

    private void attach(MaltegoEntity maltegoEntity, Attachment attachment) {
        PropertyDescriptor propertyDescriptor = AttachmentUtils.getOrCreateAttachmentsProperty((PropertyBag)maltegoEntity);
        AttachmentUtils.attach((PropertyBag)maltegoEntity, (PropertyDescriptor)propertyDescriptor, (Attachment)attachment);
    }

    public void perform(MaltegoEntity maltegoEntity, List<File> list) {
        ArrayList<MaltegoEntity> arrayList = new ArrayList<MaltegoEntity>(1);
        arrayList.add(maltegoEntity);
        super.attachFiles(arrayList, list);
    }

    public void perform(Map<MaltegoEntity, File> map) {
        HashMap<MaltegoEntity, File> hashMap = new HashMap<MaltegoEntity, File>();
        for (Map.Entry<MaltegoEntity, File> entry : map.entrySet()) {
            hashMap.put(entry.getKey(), entry.getValue());
        }
        super.attachFiles(hashMap);
    }

    private List<MaltegoEntity> getActivatedEntities() {
        ArrayList<MaltegoEntity> arrayList = new ArrayList<MaltegoEntity>();
        Node[] nodeArray = this.getActivatedNodes();
        if (nodeArray != null) {
            for (Node node : nodeArray) {
                MaltegoEntity maltegoEntity = (MaltegoEntity)node.getLookup().lookup(MaltegoEntity.class);
                if (maltegoEntity == null) continue;
                arrayList.add(maltegoEntity);
            }
        }
        return arrayList;
    }

    protected void done() {
    }
}

