/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.nodes;

import com.paterva.maltego.ui.graph.nodes.CopyToNewGraphAction;
import com.paterva.maltego.ui.graph.nodes.GraphNode;
import com.paterva.maltego.ui.graph.nodes.GraphNodeManager;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import yguard.A.A.Y;
import yguard.A.A.Z;

public class CopyToNewGraphWithNeighboursAction
extends CopyToNewGraphAction {
    private int _depth;
    private Family _family;

    public int getDepth() {
        return this._depth;
    }

    public void setDepth(int n) {
        this._depth = n;
    }

    public Family getFamily() {
        return this._family;
    }

    public void setFamily(Family family) {
        this._family = family;
    }

    public static String getFamilyName(Family family) {
        switch (family) {
            case CHILDREN: {
                return "Children";
            }
            case PARENTS: {
                return "Parents";
            }
            case BOTH: {
                return "Any";
            }
        }
        return null;
    }

    public String getName() {
        return "Copy with Neighbours";
    }

    @Override
    protected boolean performCopy(ExplorerManager explorerManager, Node[] nodeArray) {
        Node node = explorerManager.getRootContext();
        if (node instanceof GraphNode) {
            GraphNode graphNode = (GraphNode)explorerManager.getRootContext();
            Node[] nodeArray2 = this.addNeighbours(nodeArray);
            graphNode.addWithLinks(nodeArray2, true);
            return true;
        }
        return false;
    }

    private Node[] addNeighbours(Node[] nodeArray) {
        HashSet<Node> hashSet = new HashSet<Node>(Arrays.asList(nodeArray));
        HashSet<Node> hashSet2 = new HashSet<Node>(hashSet);
        for (int i = 0; i < this._depth; ++i) {
            HashSet<Node> hashSet3 = new HashSet<Node>();
            for (Node node : hashSet2) {
                hashSet3.addAll(this.getNeighbours(node));
            }
            hashSet.addAll(hashSet3);
            hashSet2 = hashSet3;
        }
        return hashSet.toArray(new Node[0]);
    }

    private Set<Node> getNeighbours(Node node) {
        Y y = (Y)node.getLookup().lookup(Y.class);
        GraphNodeManager graphNodeManager = GraphNodeManager.getInstance(y.H());
        HashSet<Node> hashSet = new HashSet<Node>();
        Z z = null;
        switch (this._family) {
            case CHILDREN: {
                z = y.G();
                break;
            }
            case PARENTS: {
                z = y.M();
                break;
            }
            case BOTH: {
                z = y.I();
            }
        }
        while (z.ok()) {
            hashSet.add(graphNodeManager.getNode(z.edge().D(y)));
            z.next();
        }
        return hashSet;
    }

    public static enum Family {
        BOTH,
        CHILDREN,
        PARENTS;

    }
}

