/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.nodes;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.graph.MaltegoGraphManager;
import com.paterva.maltego.typing.descriptor.TypeInstantiationException;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.GraphViewCookie;
import com.paterva.maltego.ui.graph.nodes.GraphNodeManager;
import com.paterva.maltego.ui.graph.view2d.LinkEdgeRealizer;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.openide.actions.NewAction;
import org.openide.actions.PasteAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;
import yguard.A.A.D;
import yguard.A.A.H;
import yguard.A.A.Y;
import yguard.A.I.;
import yguard.A.I.QA;
import yguard.A.I.S;
import yguard.A.I.o;

public class GraphNode
extends AbstractNode {
    public GraphNode(D d2, Children children) {
        super(children, Lookups.fixed((Object[])new Object[]{d2, EntityRegistry.forGraph((D)d2)}));
    }

    public Action[] getActions(boolean bl) {
        return new Action[]{SystemAction.get(NewAction.class), SystemAction.get(PasteAction.class)};
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set set = Sheet.createPropertiesSet();
        sheet.put(set);
        return sheet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Node, MaltegoEntity> add(Node[] nodeArray, boolean bl) {
        if (nodeArray != null) {
            HashMap<Node, MaltegoEntity> hashMap = new HashMap<Node, MaltegoEntity>(nodeArray.length);
            D d2 = (D)this.getLookup().lookup(D.class);
            d2.\u00e3();
            try {
                Point2D.Double[] doubleArray = bl ? this.getPositions(nodeArray) : this.calculatePositions(nodeArray.length);
                for (int i = 0; i < nodeArray.length; ++i) {
                    MaltegoEntity maltegoEntity = this.createEntityFromNode(nodeArray[i], d2);
                    if (maltegoEntity != null) {
                        this.addEntityToGraph(maltegoEntity, d2, doubleArray[i]);
                    }
                    hashMap.put(nodeArray[i], maltegoEntity);
                }
            }
            catch (TypeInstantiationException typeInstantiationException) {
                Exceptions.printStackTrace((Throwable)typeInstantiationException);
            }
            finally {
                d2.\u00d0();
                this.updateGraphView();
            }
            return hashMap;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWithLinks(Node[] nodeArray, boolean bl) {
        if (nodeArray == null || nodeArray.length == 0) {
            return;
        }
        D d2 = (D)this.getLookup().lookup(D.class);
        d2.\u00e3();
        try {
            Map<Node, MaltegoEntity> map = this.add(nodeArray, bl);
            D d3 = ((Y)nodeArray[0].getLookup().lookup(Y.class)).H();
            if (d3 != null) {
                GraphNodeManager graphNodeManager = GraphNodeManager.getInstance(d3);
                for (H h : d3.\u00d3()) {
                    Node node = graphNodeManager.getNode(h.X());
                    Node node2 = graphNodeManager.getNode(h.V());
                    if (!map.containsKey(node) || !map.containsKey(node2)) continue;
                    MaltegoEntity maltegoEntity = map.get(node);
                    MaltegoEntity maltegoEntity2 = map.get(node2);
                    MaltegoLink maltegoLink = MaltegoGraphManager.getWrapper((D)d3).link(h).createCopy();
                    this.addLinkToGraph(maltegoLink, maltegoEntity, maltegoEntity2, d2);
                }
            }
        }
        finally {
            d2.\u00d0();
            this.updateGraphView();
        }
    }

    public void addEntities(Collection<MaltegoEntity> collection) {
        this.addEntitiesToGraph(collection, (D)this.getLookup().lookup(D.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntitiesToGraph(Collection<MaltegoEntity> collection, D d2) {
        d2.\u00e3();
        try {
            Point2D.Double[] doubleArray = this.calculatePositions(collection.size());
            int n = 0;
            for (MaltegoEntity maltegoEntity : collection) {
                this.addEntityToGraph(maltegoEntity, d2, doubleArray[n++]);
            }
        }
        finally {
            d2.\u00d0();
        }
    }

    private void addLinkToGraph(MaltegoLink maltegoLink, MaltegoEntity maltegoEntity, MaltegoEntity maltegoEntity2, D d2) {
        QA qA;
        o o2;
        H h = MaltegoGraphManager.getWrapper((D)d2).connectWithEdge(maltegoEntity, maltegoEntity2, maltegoLink);
        if (d2 instanceof QA && (o2 = (qA = (QA)d2).X(h)) instanceof LinkEdgeRealizer) {
            LinkEdgeRealizer linkEdgeRealizer = (LinkEdgeRealizer)o2;
            linkEdgeRealizer.setUserData(maltegoLink);
        }
    }

    private MaltegoEntity createEntityFromNode(Node node, D d2) throws TypeInstantiationException {
        MaltegoEntity maltegoEntity = (MaltegoEntity)node.getLookup().lookup(MaltegoEntity.class);
        if (maltegoEntity != null) {
            return maltegoEntity.createCopy();
        }
        MaltegoEntitySpec maltegoEntitySpec = (MaltegoEntitySpec)node.getLookup().lookup(MaltegoEntitySpec.class);
        if (maltegoEntitySpec != null) {
            return EntityFactory.forGraph((D)d2).createInstance(maltegoEntitySpec, false);
        }
        return null;
    }

    private void addEntityToGraph(MaltegoEntity maltegoEntity, D d2, Point2D.Double double_) {
        Y y = MaltegoGraphManager.getWrapper((D)d2).addAsNode(maltegoEntity);
        if (d2 instanceof QA) {
            QA qA = (QA)d2;
            .A a2 = qA.f(y);
            a2.setCenter(double_.x, double_.y);
        }
    }

    private Point2D.Double[] getPositions(Node[] nodeArray) {
        Point2D.Double[] doubleArray = new Point2D.Double[nodeArray.length];
        if (nodeArray.length > 0) {
            D d2 = ((Y)nodeArray[0].getLookup().lookup(Y.class)).H();
            if (d2 instanceof QA) {
                QA qA = (QA)d2;
                for (int i = 0; i < nodeArray.length; ++i) {
                    Y y = (Y)nodeArray[i].getLookup().lookup(Y.class);
                    .A a2 = qA.f(y);
                    doubleArray[i] = new Point2D.Double(a2.getCenterX(), a2.getCenterY());
                }
            } else {
                doubleArray = this.calculatePositions(nodeArray.length);
            }
        }
        return doubleArray;
    }

    private Point2D.Double[] calculatePositions(int n) {
        S s;
        JComponent jComponent;
        GraphViewCookie graphViewCookie;
        int n2 = 120;
        double d2 = 0.0;
        double d3 = 0.0;
        TopComponent topComponent = GraphEditorRegistry.getDefault().getTopmost();
        if (topComponent != null && (graphViewCookie = (GraphViewCookie)topComponent.getLookup().lookup(GraphViewCookie.class)) != null && (jComponent = graphViewCookie.getGraphView().getViewControl()).isShowing() && jComponent instanceof S) {
            s = (S)jComponent;
            Point point = MouseInfo.getPointerInfo().getLocation();
            Point point2 = jComponent.getLocationOnScreen();
            Rectangle rectangle = jComponent.getBounds();
            rectangle.translate(point2.x, point2.y);
            if (!rectangle.contains(point)) {
                SwingUtilities.convertPointFromScreen(point2, jComponent);
                d2 = s.D(point2.x) + 60.0;
                d3 = s.C(point2.y) + 60.0;
            } else {
                SwingUtilities.convertPointFromScreen(point, jComponent);
                d2 = s.D(point.x);
                d3 = s.C(point.y);
            }
        }
        int n3 = (int)Math.ceil(Math.sqrt(n));
        int n4 = 0;
        s = new Point2D.Double[n];
        double d4 = d2;
        double d5 = d3;
        for (int i = 0; i < n3; ++i) {
            d4 = d2;
            for (int j = 0; j < n3; ++j) {
                if (n4 < ((S)s).length) {
                    s[n4] = new Point2D.Double(d4, d5);
                }
                ++n4;
                d4 += 120.0;
            }
            d5 += 120.0;
        }
        return s;
    }

    private void updateGraphView() {
        D d2 = (D)this.getLookup().lookup(D.class);
        if (d2 instanceof QA) {
            QA qA = (QA)d2;
            qA.\u011b();
        }
    }

    void remove(Node node) {
        if (node != null) {
            MaltegoEntity maltegoEntity = (MaltegoEntity)node.getLookup().lookup(MaltegoEntity.class);
            if (maltegoEntity != null) {
                MaltegoGraphManager.get((D)((D)this.getLookup().lookup(D.class))).remove(maltegoEntity);
            } else {
                MaltegoLink maltegoLink = (MaltegoLink)node.getLookup().lookup(MaltegoLink.class);
                if (maltegoLink != null) {
                    MaltegoGraphManager.get((D)((D)this.getLookup().lookup(D.class))).remove(maltegoLink);
                }
            }
        }
    }

    void remove(Node[] nodeArray) {
        D d2 = (D)this.getLookup().lookup(D.class);
        d2.\u00e3();
        for (int i = 0; i < nodeArray.length; ++i) {
            this.remove(nodeArray[i]);
        }
        d2.\u00d0();
    }
}

