/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph;

import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.graph.Cursors;
import com.paterva.maltego.graph.EdgeCursorIterator;
import com.paterva.maltego.graph.HashMapDataAdapter;
import com.paterva.maltego.graph.MaltegoGraphStructure;
import yguard.A.A.D;
import yguard.A.A.H;
import yguard.A.A.I;
import yguard.A.A.J;
import yguard.A.A.K;
import yguard.A.A.Y;

public abstract class GraphStructureWrapper
implements MaltegoGraphStructure {
    private static final String NODE_MAP_PROVIDER_KEY = "maltego.NodeMap";
    private static final String EDGE_MAP_PROVIDER_KEY = "maltego.EdgeMap";
    private static final String ENTITY_MAP_PROVIDER_KEY = "maltego.EntityMap";
    private static final String LINK_MAP_PROVIDER_KEY = "maltego.LinkMap";
    private D _graph;
    private I _nodes;
    private J _edges;
    private HashMapDataAdapter<MaltegoEntity, Y> _entities;
    private HashMapDataAdapter<MaltegoLink, H> _links;

    protected GraphStructureWrapper(D d) {
        this._graph = d;
        this._nodes = GraphStructureWrapper.getNodeMap(d);
        this._edges = GraphStructureWrapper.getEdgeMap(d);
        this._entities = GraphStructureWrapper.getEntityMap(d);
        this._links = GraphStructureWrapper.getLinkMap(d);
    }

    private static HashMapDataAdapter<MaltegoEntity, Y> getEntityMap(D d) {
        HashMapDataAdapter hashMapDataAdapter = (HashMapDataAdapter)d.G((Object)ENTITY_MAP_PROVIDER_KEY);
        if (hashMapDataAdapter == null) {
            hashMapDataAdapter = new HashMapDataAdapter();
            d.A((Object)ENTITY_MAP_PROVIDER_KEY, hashMapDataAdapter);
        }
        return hashMapDataAdapter;
    }

    private static HashMapDataAdapter<MaltegoLink, H> getLinkMap(D d) {
        HashMapDataAdapter hashMapDataAdapter = (HashMapDataAdapter)d.G((Object)LINK_MAP_PROVIDER_KEY);
        if (hashMapDataAdapter == null) {
            hashMapDataAdapter = new HashMapDataAdapter();
            d.A((Object)LINK_MAP_PROVIDER_KEY, hashMapDataAdapter);
        }
        return hashMapDataAdapter;
    }

    private static I getNodeMap(D d) {
        I i = (I)d.G((Object)NODE_MAP_PROVIDER_KEY);
        if (i == null) {
            i = d.\u00d5();
            d.A((Object)NODE_MAP_PROVIDER_KEY, (K)i);
        }
        return i;
    }

    private static J getEdgeMap(D d) {
        J j = (J)d.G((Object)EDGE_MAP_PROVIDER_KEY);
        if (j == null) {
            j = d.\u00e6();
            d.A((Object)EDGE_MAP_PROVIDER_KEY, (K)j);
        }
        return j;
    }

    protected D graph() {
        return this._graph;
    }

    protected I nodeMap() {
        return this._nodes;
    }

    protected J edgeMap() {
        return this._edges;
    }

    protected HashMapDataAdapter<MaltegoEntity, Y> entityMap() {
        return this._entities;
    }

    protected HashMapDataAdapter<MaltegoLink, H> linkMap() {
        return this._links;
    }

    public MaltegoEntity entity(Y y) {
        return (MaltegoEntity)this.nodeMap().get((Object)y);
    }

    public MaltegoLink link(H h) {
        return (MaltegoLink)this.edgeMap().get((Object)h);
    }

    public Y node(MaltegoEntity maltegoEntity) {
        return this.entityMap().get(maltegoEntity);
    }

    public H edge(MaltegoLink maltegoLink) {
        return this.linkMap().get(maltegoLink);
    }

    public D getGraph() {
        return this._graph;
    }

    @Override
    public Iterable<MaltegoEntity> entities() {
        return this._entities.keys();
    }

    @Override
    public Iterable<MaltegoLink> links() {
        return this._links.keys();
    }

    @Override
    public int entityCount() {
        return this._entities.size();
    }

    @Override
    public int linkCount() {
        return this._links.size();
    }

    @Override
    public Iterable<MaltegoLink> incoming(MaltegoEntity maltegoEntity) {
        return new EdgeCursorIterator<MaltegoLink>(this, this.node(maltegoEntity).M());
    }

    @Override
    public Iterable<MaltegoLink> outgoing(MaltegoEntity maltegoEntity) {
        return new EdgeCursorIterator<MaltegoLink>(this, this.node(maltegoEntity).G());
    }

    @Override
    public Iterable<MaltegoLink> links(MaltegoEntity maltegoEntity) {
        return new EdgeCursorIterator<MaltegoLink>(this, this.node(maltegoEntity).I());
    }

    @Override
    public int inDegree(MaltegoEntity maltegoEntity) {
        return this.node(maltegoEntity).O();
    }

    @Override
    public int outDegree(MaltegoEntity maltegoEntity) {
        return this.node(maltegoEntity).C();
    }

    @Override
    public int degree(MaltegoEntity maltegoEntity) {
        return this.node(maltegoEntity).C();
    }

    @Override
    public MaltegoEntity source(MaltegoLink maltegoLink) {
        Y y;
        H h = this.edge(maltegoLink);
        if (h != null && (y = h.X()) != null) {
            return this.entity(y);
        }
        return null;
    }

    @Override
    public MaltegoEntity target(MaltegoLink maltegoLink) {
        Y y;
        H h = this.edge(maltegoLink);
        if (h != null && (y = h.V()) != null) {
            return this.entity(y);
        }
        return null;
    }

    @Override
    public MaltegoEntity getEntity(Guid guid) {
        return this.entityMap().getKey(guid);
    }

    @Override
    public MaltegoLink getLink(Guid guid) {
        return this.linkMap().getKey(guid);
    }

    @Override
    public Iterable<MaltegoEntity> parents(MaltegoEntity maltegoEntity) {
        return Cursors.parentEntities(this.node(maltegoEntity));
    }

    @Override
    public Iterable<MaltegoEntity> children(MaltegoEntity maltegoEntity) {
        return Cursors.childEntities(this.node(maltegoEntity));
    }
}

