/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.descriptor;

import com.paterva.maltego.transform.descriptor.RepositoryEvent;
import com.paterva.maltego.transform.descriptor.RepositoryListener;
import java.util.LinkedList;

public class AbstractRepository {
    private LinkedList<RepositoryListener> _listeners;

    public void addRepositoryListener(RepositoryListener repositoryListener) {
        if (this._listeners == null) {
            this._listeners = new LinkedList();
        }
        this._listeners.add(repositoryListener);
    }

    public void removeRepositoryListener(RepositoryListener repositoryListener) {
        if (this._listeners != null) {
            this._listeners.remove(repositoryListener);
        }
    }

    protected void fireItemAdded(Object object) {
        if (this._listeners != null) {
            for (RepositoryListener repositoryListener : this._listeners) {
                repositoryListener.itemAdded(new RepositoryEvent<Object>(this, object));
            }
        }
    }

    protected void fireItemRemoved(Object object) {
        if (this._listeners != null) {
            for (RepositoryListener repositoryListener : this._listeners) {
                repositoryListener.itemRemoved(new RepositoryEvent<Object>(this, object));
            }
        }
    }

    protected void fireItemChanged(Object object) {
        if (this._listeners != null) {
            for (RepositoryListener repositoryListener : this._listeners) {
                repositoryListener.itemChanged(new RepositoryEvent<Object>(this, object));
            }
        }
    }
}

