/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.descriptor;

import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.transform.descriptor.Constraint;
import com.paterva.maltego.transform.descriptor.InheritedTypesProvider;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CompoundConstraint<T extends Constraint>
implements Constraint,
Iterable<T> {
    private List<T> _constraints;

    public CompoundConstraint() {
    }

    public CompoundConstraint(CompoundConstraint<T> compoundConstraint) {
        this.constraints().addAll(super.constraints());
    }

    public void add(T t) {
        this.constraints().add(t);
    }

    @Override
    public Iterator<T> iterator() {
        return this.constraints().iterator();
    }

    private List<T> constraints() {
        if (this._constraints == null) {
            this._constraints = new LinkedList<T>();
        }
        return this._constraints;
    }

    public void remove(T t) {
        if (this._constraints != null) {
            this._constraints.remove(t);
        }
    }

    @Override
    public boolean isSatisfiedByAny(Iterable<? extends TypedPropertyBag> iterable, InheritedTypesProvider inheritedTypesProvider) {
        if (this._constraints == null) {
            return true;
        }
        for (Constraint constraint : this._constraints) {
            boolean bl = constraint.isSatisfiedByAny(iterable, inheritedTypesProvider);
            if (bl) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getDisplay() {
        if (this._constraints == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (Constraint constraint : this._constraints) {
            stringBuilder.append(constraint.getDisplay());
            if (n < this._constraints.size() - 1) {
                stringBuilder.append(", ");
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.getDisplay();
    }
}

