/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util;

import java.awt.Color;

public class ColorUtilities {
    private ColorUtilities() {
    }

    public static Color darker(Color color, int n) {
        return ColorUtilities.brighter(color, -n);
    }

    public static Color brighter(Color color, int n) {
        return ColorUtilities.brighterTranslucent(color, n, 255);
    }

    public static Color brighterTranslucent(Color color, int n, int n2) {
        int n3 = color.getRed() + n;
        int n4 = color.getBlue() + n;
        int n5 = color.getGreen() + n;
        int n6 = n2;
        if (n6 < 0) {
            n6 = 0;
        }
        if (n6 > 255) {
            n6 = 255;
        }
        if (n3 > 255) {
            n3 = 255;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n5 > 255) {
            n5 = 255;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        if (n4 > 255) {
            n4 = 255;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        return new Color(n3, n5, n4, n6);
    }

    public static Color darkerTranslucent(Color color, int n, int n2) {
        return ColorUtilities.brighterTranslucent(color, -n, n2);
    }

    public static Color makeTranslucent(Color color, int n) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
    }

    public static Color decode(String string) {
        if (string == null || string.isEmpty()) {
            return Color.black;
        }
        return Color.decode(string);
    }

    public static String encode(Color color) {
        char[] cArray = new char[7];
        cArray[0] = 35;
        String string = Integer.toHexString(color.getRed());
        if (string.length() == 1) {
            cArray[1] = 48;
            cArray[2] = string.charAt(0);
        } else {
            cArray[1] = string.charAt(0);
            cArray[2] = string.charAt(1);
        }
        string = Integer.toHexString(color.getGreen());
        if (string.length() == 1) {
            cArray[3] = 48;
            cArray[4] = string.charAt(0);
        } else {
            cArray[3] = string.charAt(0);
            cArray[4] = string.charAt(1);
        }
        string = Integer.toHexString(color.getBlue());
        if (string.length() == 1) {
            cArray[5] = 48;
            cArray[6] = string.charAt(0);
        } else {
            cArray[5] = string.charAt(0);
            cArray[6] = string.charAt(1);
        }
        return String.valueOf(cArray);
    }

    public static Color invert(Color color) {
        float[] fArray = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
        int n = Color.HSBtoRGB(1.0f - fArray[0], fArray[1], fArray[2]);
        return new Color(n);
    }
}

