/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.dialog;

import com.paterva.maltego.util.FileExtensionFileFilter;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import java.io.File;
import java.lang.reflect.Method;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.openide.WizardDescriptor;
import org.openide.util.NbPreferences;

public abstract class FileController
extends ValidatingController<JFileChooser>
implements WizardDescriptor.ValidatingPanel {
    public static final String SELECTED_FILE = "selectedFile";
    public static final String BROWSE_DIR = "browseDir";
    private String _fileType;
    private String[] _fileExtensions;
    private int _dialogType;

    public FileController(int n, String string, String[] stringArray) {
        this.setName("Select File");
        this._dialogType = n;
        this._fileType = string;
        this._fileExtensions = stringArray;
    }

    @Override
    protected String getFirstError(JFileChooser jFileChooser) {
        return null;
    }

    @Override
    protected JFileChooser createComponent() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setName(this.getName());
        jFileChooser.setDialogType(this._dialogType);
        jFileChooser.setControlButtonsAreShown(false);
        jFileChooser.setMultiSelectionEnabled(false);
        if (this._dialogType == 1) {
            jFileChooser.setAcceptAllFileFilterUsed(false);
        }
        if (this._fileExtensions != null && this._fileType != null) {
            jFileChooser.setFileFilter((FileFilter)new FileExtensionFileFilter(this._fileExtensions, this._fileType));
        }
        return jFileChooser;
    }

    @Override
    public void readSettings(WizardDescriptor wizardDescriptor) {
        File file = (File)wizardDescriptor.getProperty(SELECTED_FILE);
        String string = (String)wizardDescriptor.getProperty(BROWSE_DIR);
        if (file != null) {
            ((JFileChooser)this.component()).setSelectedFile(file);
        } else if (!StringUtilities.isNullOrEmpty((String)string)) {
            ((JFileChooser)this.component()).setCurrentDirectory(new File(string));
        }
    }

    @Override
    public void storeSettings(WizardDescriptor wizardDescriptor) {
        Object object;
        File file = null;
        try {
            object = ((JFileChooser)this.component()).getUI().getClass().getDeclaredMethod("getFileName", new Class[0]);
            String string = (String)((Method)object).invoke((Object)((JFileChooser)this.component()).getUI(), new Object[0]);
            file = new File(string);
            if (!file.isAbsolute()) {
                file = new File(((JFileChooser)this.component()).getCurrentDirectory(), string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object = null;
        if (file != null) {
            if (file.isDirectory()) {
                object = file.getAbsolutePath();
                file = null;
            } else {
                object = file.getAbsoluteFile().getParent();
                if (this._dialogType == 1 && !file.getName().endsWith("." + this._fileExtensions[0])) {
                    file = new File(file.getPath() + "." + this._fileExtensions[0]);
                }
            }
        }
        wizardDescriptor.putProperty(SELECTED_FILE, (Object)file);
        wizardDescriptor.putProperty(BROWSE_DIR, object);
        if (object != null) {
            NbPreferences.root().put(BROWSE_DIR, (String)object);
        }
    }

    protected File getSelectedFile() {
        return (File)this.getDescriptor().getProperty(SELECTED_FILE);
    }
}

