/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.impl;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.MutableComboBoxModel;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.FindSupport;
import org.netbeans.editor.MultiKeymap;
import org.netbeans.editor.SideBarFactory;
import org.netbeans.editor.Utilities;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public final class SearchBar
extends JPanel {
    private static final Logger LOG = Logger.getLogger(SearchBar.class.getName());
    private static final boolean CLOSE_ON_ENTER = Boolean.getBoolean("org.netbeans.modules.editor.search.closeOnEnter");
    private static final Insets BUTTON_INSETS = new Insets(2, 1, 0, 1);
    private static final Color NOT_FOUND = Color.RED.darker();
    private static final Color INVALID_REGEXP = Color.red;
    private static final int SEARCH_DELAY_TIME_LONG = 300;
    private static final int SEARCH_DELAY_TIME_SHORT = 20;
    private static final int defaultIncremantalSearchComboWidth = 200;
    private static final int maxIncremantalSearchComboWidth = 350;
    public static final String INCREMENTAL_SEARCH_FORWARD = "incremental-search-forward";
    public static final String INCREMENTAL_SEARCH_BACKWARD = "incremental-search-backward";
    private JTextComponent component;
    private JButton closeButton;
    private JButton expandButton;
    private JLabel findLabel;
    private JComboBox incrementalSearchComboBox;
    private JTextField incrementalSearchTextField;
    private DocumentListener incrementalSearchTextFieldListener;
    private JButton findNextButton;
    private JButton findPreviousButton;
    private JCheckBox matchCaseCheckBox;
    private JCheckBox wholeWordsCheckBox;
    private JCheckBox regexpCheckBox;
    private JCheckBox highlightCheckBox;
    private Map<Object, Object> findProps;
    private JPopupMenu expandPopup;
    private JPanel padding;
    private boolean searched = false;
    private final List<Component> inBar = new ArrayList<Component>();
    private final LinkedList<Component> inPopup = new LinkedList();
    private final List<Component> barOrder = new ArrayList<Component>();
    private boolean isPopupGoingToShow = false;
    private boolean isPopupShown = false;
    private static final String DEFAULT_PROFILE = "NetBeans";
    private static final String FATTR_CURRENT_KEYMAP_PROFILE = "currentKeymap";
    private static final String KEYMAPS_FOLDER = "Keymaps";

    public SearchBar(final JTextComponent component) {
        this.component = component;
        component.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (e.getOppositeComponent() instanceof JRootPane) {
                    return;
                }
                SearchBar.this.looseFocus();
            }
        });
        FindSupport findSupport = FindSupport.getFindSupport();
        this.findProps = new HashMap<Object, Object>(findSupport.getFindProperties());
        this.setLayout(new BoxLayout(this, 2));
        this.setFocusCycleRoot(true);
        Color bgColor = this.getBackground();
        bgColor = new Color(Math.max(0, bgColor.getRed() - 20), Math.max(0, bgColor.getGreen() - 20), Math.max(0, bgColor.getBlue() - 20));
        this.setBackground(bgColor);
        this.setForeground(UIManager.getColor("textText"));
        PropertyChangeListener pcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt == null || !"keymap".equals(evt.getPropertyName())) {
                    return;
                }
                Keymap keymap = component.getKeymap();
                if (keymap instanceof MultiKeymap) {
                    Action[] actions;
                    MultiKeymap multiKeymap = (MultiKeymap)keymap;
                    for (Action action : actions = component.getActions()) {
                        Action incrementalSearchBackwardAction;
                        InputMap inputMap;
                        KeyStroke[] keyStrokes;
                        String actionName = (String)action.getValue("Name");
                        if (actionName == null) {
                            LOG.log(Level.WARNING, "SearchBar: Null Action.NAME property of action: {0}\n", action);
                            continue;
                        }
                        if (actionName.equals(SearchBar.INCREMENTAL_SEARCH_FORWARD) || actionName.equals("find-next")) {
                            Action incrementalSearchForwardAction = action;
                            keyStrokes = multiKeymap.getKeyStrokesForAction(incrementalSearchForwardAction);
                            if (keyStrokes == null) continue;
                            inputMap = SearchBar.this.getInputMap(1);
                            for (KeyStroke ks : keyStrokes) {
                                LOG.log(Level.FINE, "found forward search action, {0}", ks);
                                inputMap.put(ks, actionName);
                            }
                            SearchBar.this.getActionMap().put(actionName, new AbstractAction(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    SearchBar.this.findNext();
                                }
                            });
                            continue;
                        }
                        if (!actionName.equals(SearchBar.INCREMENTAL_SEARCH_BACKWARD) && !actionName.equals("find-previous") || (keyStrokes = multiKeymap.getKeyStrokesForAction(incrementalSearchBackwardAction = action)) == null) continue;
                        inputMap = SearchBar.this.getInputMap(1);
                        for (KeyStroke ks : keyStrokes) {
                            LOG.log(Level.FINE, "found backward search action, {0}", ks);
                            inputMap.put(ks, actionName);
                        }
                        SearchBar.this.getActionMap().put(actionName, new AbstractAction(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                SearchBar.this.findPrevious();
                            }
                        });
                    }
                }
            }
        };
        component.addPropertyChangeListener(pcl);
        pcl.propertyChange(new PropertyChangeEvent(this, "keymap", null, null));
        this.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0, true), "loose-focus");
        this.getActionMap().put("loose-focus", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!CLOSE_ON_ENTER && !SearchBar.this.searched) {
                    SearchBar.this.findNext();
                }
                SearchBar.this.looseFocus();
            }
        });
        this.closeButton = new JButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/editor/resources/find_close.png", (boolean)false));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.looseFocus();
            }
        });
        this.closeButton.setToolTipText(NbBundle.getMessage(SearchBar.class, (String)"TOOLTIP_CloseIncrementalSearchSidebar"));
        this.processButton(this.closeButton);
        this.expandButton = new JButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/editor/resources/find_expand.png", (boolean)false));
        this.expandButton.setMnemonic(NbBundle.getMessage(SearchBar.class, (String)"CTL_ExpandButton_Mnemonic").charAt(0));
        this.processButton(this.expandButton);
        this.expandButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean state = !SearchBar.this.isPopupShown;
                SearchBar.this.isPopupShown = state;
                if (state) {
                    SearchBar.this.showExpandedMenu();
                } else {
                    SearchBar.this.hideExpandedMenu();
                }
            }
        });
        this.findLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.findLabel, (String)NbBundle.getMessage(SearchBar.class, (String)"CTL_Find"));
        this.incrementalSearchComboBox = new JComboBox(){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getPreferredSize() {
                int editsize = this.getEditor().getEditorComponent().getPreferredSize().width + 10;
                int width = editsize > 200 && editsize < 350 ? editsize : (editsize >= 350 ? 350 : 200);
                return new Dimension(width, super.getPreferredSize().height);
            }
        };
        this.findLabel.setLabelFor(this.incrementalSearchComboBox);
        this.incrementalSearchComboBox.setEditable(true);
        this.incrementalSearchTextField = (JTextField)this.incrementalSearchComboBox.getEditor().getEditorComponent();
        this.incrementalSearchTextField.setToolTipText(NbBundle.getMessage(SearchBar.class, (String)"TOOLTIP_IncrementalSearchText"));
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.incrementalSearch();
            }
        };
        final Timer searchDelayTimer = new Timer(300, al);
        searchDelayTimer.setRepeats(false);
        this.incrementalSearchTextFieldListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                SearchBar.this.searched = false;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SearchBar.this.searched = false;
                SearchBar.this.computeLayout();
                if (SearchBar.this.incrementalSearchTextField.getText().length() > 3) {
                    searchDelayTimer.setInitialDelay(20);
                }
                searchDelayTimer.restart();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SearchBar.this.searched = false;
                SearchBar.this.computeLayout();
                if (SearchBar.this.incrementalSearchTextField.getText().length() <= 3) {
                    searchDelayTimer.setInitialDelay(300);
                }
                searchDelayTimer.restart();
            }
        };
        this.incrementalSearchTextField.getDocument().addDocumentListener(this.incrementalSearchTextFieldListener);
        ActionMap origActionMap = this.incrementalSearchTextField.getActionMap();
        ActionMap newActionMap = new ActionMap();
        for (Object key : origActionMap.allKeys()) {
            newActionMap.put(key, origActionMap.get(key));
        }
        this.incrementalSearchTextField.setActionMap(newActionMap);
        this.incrementalSearchTextField.getInputMap().put(KeyStroke.getKeyStroke(10, 0, true), "incremental-find-next");
        this.incrementalSearchTextField.getActionMap().put("incremental-find-next", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!CLOSE_ON_ENTER && !SearchBar.this.searched) {
                    SearchBar.this.findNext();
                }
                SearchBar.this.findNext();
                if (CLOSE_ON_ENTER) {
                    SearchBar.this.looseFocus();
                }
            }
        });
        this.incrementalSearchTextField.getInputMap().put(KeyStroke.getKeyStroke(10, 1, true), "incremental-find-previous");
        this.incrementalSearchTextField.getActionMap().put("incremental-find-previous", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.findPrevious();
                if (CLOSE_ON_ENTER) {
                    SearchBar.this.looseFocus();
                }
            }
        });
        this.incrementalSearchTextField.getActionMap().remove("toggle-componentOrientation");
        if (this.getCurrentKeyMapProfile().startsWith("Emacs")) {
            String actionName = "caret-begin-line";
            class JumpOutOfSearchAction
            extends AbstractAction {
                private String actionName;

                public JumpOutOfSearchAction(String n) {
                    this.actionName = n;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchBar.this.looseFocus();
                    ActionEvent ev = new ActionEvent(component, e.getID(), e.getActionCommand(), e.getModifiers());
                    Action action = component.getActionMap().get(this.actionName);
                    action.actionPerformed(ev);
                }
            }
            JumpOutOfSearchAction a1 = new JumpOutOfSearchAction(actionName);
            this.incrementalSearchTextField.getActionMap().put(actionName, a1);
            actionName = "caret-end-line";
            JumpOutOfSearchAction a2 = new JumpOutOfSearchAction(actionName);
            this.incrementalSearchTextField.getActionMap().put(actionName, a2);
            this.incrementalSearchTextField.getInputMap().put(KeyStroke.getKeyStroke(80, 2, false), "caret-up-alt");
            actionName = "caret-up";
            JumpOutOfSearchAction a3 = new JumpOutOfSearchAction(actionName);
            this.incrementalSearchTextField.getActionMap().put("caret-up-alt", a3);
            this.incrementalSearchTextField.getInputMap().put(KeyStroke.getKeyStroke(78, 2, false), "caret-down-alt");
            actionName = "caret-down";
            JumpOutOfSearchAction a4 = new JumpOutOfSearchAction(actionName);
            this.incrementalSearchTextField.getActionMap().put("caret-down-alt", a4);
        }
        this.findNextButton = new JButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/editor/resources/find_next.png", (boolean)false));
        Mnemonics.setLocalizedText((AbstractButton)this.findNextButton, (String)NbBundle.getMessage(SearchBar.class, (String)"CTL_FindNext"));
        this.findNextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.findNext();
            }
        });
        this.processButton(this.findNextButton);
        this.findPreviousButton = new JButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/editor/resources/find_previous.png", (boolean)false));
        Mnemonics.setLocalizedText((AbstractButton)this.findPreviousButton, (String)NbBundle.getMessage(SearchBar.class, (String)"CTL_FindPrevious"));
        this.findPreviousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.findPrevious();
            }
        });
        this.processButton(this.findPreviousButton);
        this.matchCaseCheckBox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.matchCaseCheckBox, (String)NbBundle.getMessage(SearchBar.class, (String)"CTL_MatchCase"));
        this.matchCaseCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.switchMatchCase();
                SearchBar.this.incrementalSearch();
            }
        });
        this.matchCaseCheckBox.setSelected(this.getMatchCase());
        this.processButton(this.matchCaseCheckBox);
        this.wholeWordsCheckBox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.wholeWordsCheckBox, (String)NbBundle.getMessage(SearchBar.class, (String)"CTL_WholeWords"));
        this.wholeWordsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.switchWholeWords();
                SearchBar.this.incrementalSearch();
            }
        });
        this.wholeWordsCheckBox.setSelected(this.getWholeWords());
        this.wholeWordsCheckBox.setEnabled(!this.getRegExp());
        this.processButton(this.wholeWordsCheckBox);
        this.regexpCheckBox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.regexpCheckBox, (String)NbBundle.getMessage(SearchBar.class, (String)"CTL_Regexp"));
        this.regexpCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.switchRegExp();
                SearchBar.this.wholeWordsCheckBox.setEnabled(!SearchBar.this.regexpCheckBox.isSelected());
                SearchBar.this.incrementalSearch();
            }
        });
        this.regexpCheckBox.setSelected(this.getRegExp());
        this.processButton(this.regexpCheckBox);
        this.highlightCheckBox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.highlightCheckBox, (String)NbBundle.getMessage(SearchBar.class, (String)"CTL_Highlight"));
        this.highlightCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.switchHighlightResults();
                SearchBar.this.incrementalSearch();
            }
        });
        this.highlightCheckBox.setSelected(this.getHighlightResults());
        this.processButton(this.highlightCheckBox);
        this.expandPopup = new JPopupMenu();
        this.expandPopup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                if (SearchBar.this.expandButton.getMousePosition() == null) {
                    SearchBar.this.expandButton.setContentAreaFilled(false);
                    SearchBar.this.expandButton.setBorderPainted(false);
                    SearchBar.this.isPopupShown = false;
                }
            }
        });
        JPanel spacer = new JPanel();
        spacer.setSize(4, 4);
        spacer.setMaximumSize(new Dimension(4, 4));
        spacer.setOpaque(false);
        this.add(spacer);
        this.add(this.findLabel);
        this.add(this.incrementalSearchComboBox);
        JToolBar.Separator leftSeparator = new JToolBar.Separator();
        leftSeparator.setOrientation(1);
        this.add(leftSeparator);
        this.add(this.findPreviousButton);
        this.add(this.findNextButton);
        JToolBar.Separator rightSeparator = new JToolBar.Separator();
        rightSeparator.setOrientation(1);
        this.add(rightSeparator);
        this.add(this.matchCaseCheckBox);
        this.add(this.wholeWordsCheckBox);
        this.add(this.regexpCheckBox);
        this.add(this.highlightCheckBox);
        this.add(this.expandButton);
        this.padding = new JPanel();
        this.padding.setOpaque(false);
        this.add(this.padding);
        this.add(this.closeButton);
        this.makeBarExpandable();
        this.setVisible(false);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                SearchBar.this.computeLayout();
            }
        });
    }

    private String getCurrentKeyMapProfile() {
        Object o;
        String currentKeyMapProfile = null;
        FileObject fo = FileUtil.getConfigFile((String)KEYMAPS_FOLDER);
        if (fo != null && (o = fo.getAttribute(FATTR_CURRENT_KEYMAP_PROFILE)) instanceof String) {
            currentKeyMapProfile = (String)o;
        }
        if (currentKeyMapProfile == null) {
            currentKeyMapProfile = DEFAULT_PROFILE;
        }
        return currentKeyMapProfile;
    }

    private void makeBarExpandable() {
        this.inBar.add(this.matchCaseCheckBox);
        this.inBar.add(this.wholeWordsCheckBox);
        this.inBar.add(this.regexpCheckBox);
        this.inBar.add(this.highlightCheckBox);
        this.barOrder.addAll(Arrays.asList(this.getComponents()));
        this.remove(this.expandButton);
    }

    private void computeLayout() {
        Component c;
        Container parent = this.getParent();
        int parentWidth = parent.getWidth();
        int totalWidth = 0;
        boolean change = false;
        for (Component c2 : this.getComponents()) {
            if (c2 == this.padding) continue;
            totalWidth += c2.getWidth();
        }
        if (totalWidth <= parentWidth) {
            while (!this.inPopup.isEmpty() && (totalWidth += (c = this.inPopup.getFirst()).getWidth()) <= parentWidth) {
                this.inPopup.removeFirst();
                this.inBar.add(c);
                this.expandPopup.remove(c);
                this.add(c, this.barOrder.indexOf(c));
                change = true;
            }
        } else {
            while (totalWidth > parentWidth && !this.inBar.isEmpty()) {
                c = this.inBar.remove(this.inBar.size() - 1);
                this.inPopup.addFirst(c);
                this.remove(c);
                this.expandPopup.add(c, 0);
                totalWidth -= c.getWidth();
                change = true;
            }
        }
        if (change) {
            if (this.inPopup.isEmpty()) {
                this.remove(this.expandButton);
            } else if (this.getComponentIndex(this.expandButton) < 0) {
                this.add((Component)this.expandButton, this.getComponentIndex(this.padding));
            }
            this.revalidate();
            this.expandPopup.invalidate();
            this.expandPopup.validate();
        }
    }

    private int getComponentIndex(Component c) {
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (c != comps[i]) continue;
            return i;
        }
        return -1;
    }

    private void showExpandedMenu() {
        if (!this.inPopup.isEmpty() && !this.expandPopup.isVisible()) {
            this.isPopupGoingToShow = true;
            Insets ins = this.expandPopup.getInsets();
            this.expandPopup.show(this.expandButton, 0, -(this.matchCaseCheckBox.getHeight() * this.inPopup.size() + ins.top + ins.bottom));
        }
    }

    private void hideExpandedMenu() {
        if (this.expandPopup.isVisible()) {
            this.expandPopup.setVisible(false);
            this.incrementalSearch();
            this.incrementalSearchTextField.requestFocusInWindow();
        }
    }

    @Override
    public String getName() {
        return "editorSearchBar";
    }

    private void gainFocus() {
        FindSupport findSupport = FindSupport.getFindSupport();
        this.findProps = new HashMap<Object, Object>(findSupport.getFindProperties());
        if (this.isVisible()) {
            this.incrementalSearchTextField.requestFocusInWindow();
            return;
        }
        this.computeLayout();
        this.isPopupShown = false;
        this.setVisible(true);
        this.initBlockSearch();
        this.incrementalSearchTextField.requestFocusInWindow();
        if (this.incrementalSearchTextField.getText().length() > 0) {
            this.incrementalSearchTextField.selectAll();
            this.findPreviousButton.setEnabled(true);
            this.findNextButton.setEnabled(true);
        } else {
            this.findPreviousButton.setEnabled(false);
            this.findNextButton.setEnabled(false);
        }
        this.wholeWordsCheckBox.setSelected(this.getWholeWords());
        this.wholeWordsCheckBox.setEnabled(!this.getRegExp());
        this.matchCaseCheckBox.setSelected(this.getMatchCase());
        this.regexpCheckBox.setSelected(this.getRegExp());
        this.highlightCheckBox.setSelected(this.getHighlightResults());
        this.searched = false;
    }

    private void looseFocus() {
        if (!this.isVisible()) {
            return;
        }
        if (this.isPopupGoingToShow) {
            this.isPopupGoingToShow = false;
            return;
        }
        Utilities.setStatusText((JTextComponent)this.component, (String)"");
        FindSupport.getFindSupport().setBlockSearchHighlight(0, 0);
        FindSupport.getFindSupport().incSearchReset();
        this.setVisible(false);
        this.component.requestFocusInWindow();
    }

    private void incrementalSearch() {
        String incrementalSearchText = this.incrementalSearchTextField.getText();
        boolean empty = incrementalSearchText.length() <= 0;
        this.findPreviousButton.setEnabled(!empty);
        this.findNextButton.setEnabled(!empty);
        FindSupport findSupport = FindSupport.getFindSupport();
        this.findProps.put("find-what", incrementalSearchText);
        this.findProps.put("find-match-case", this.matchCaseCheckBox.isSelected());
        this.findProps.put("find-whole-words", this.wholeWordsCheckBox.isSelected());
        this.findProps.put("find-reg-exp", this.regexpCheckBox.isSelected());
        this.findProps.put("find-highlight-search", !empty && this.highlightCheckBox.isSelected());
        this.findProps.put("find-backward-search", false);
        this.findProps.put("find-inc-search", true);
        findSupport.putFindProperties(this.findProps);
        int caretPosition = this.component.getCaretPosition();
        if (this.regexpCheckBox.isSelected()) {
            Pattern pattern;
            String patternErrorMsg = null;
            try {
                pattern = Pattern.compile(incrementalSearchText);
            }
            catch (PatternSyntaxException e) {
                pattern = null;
                patternErrorMsg = e.getDescription();
            }
            if (pattern != null) {
                this.incrementalSearchTextField.setForeground(UIManager.getColor("textText"));
                Utilities.setStatusText((JTextComponent)this.component, (String)"", (int)900);
            } else {
                this.incrementalSearchTextField.setForeground(INVALID_REGEXP);
                Utilities.setStatusBoldText((JTextComponent)this.component, (String)NbBundle.getMessage(SearchBar.class, (String)"incremental-search-invalid-regexp", (Object)patternErrorMsg));
            }
        } else if (findSupport.incSearch(this.findProps, caretPosition) || empty) {
            this.incrementalSearchTextField.setForeground(UIManager.getColor("textText"));
            Utilities.setStatusText((JTextComponent)this.component, (String)"", (int)900);
        } else {
            this.incrementalSearchTextField.setForeground(NOT_FOUND);
            Utilities.setStatusText((JTextComponent)this.component, (String)NbBundle.getMessage(SearchBar.class, (String)"incremental-search-not-found", (Object)incrementalSearchText), (int)900);
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void findNext() {
        this.find(true);
    }

    private void findPrevious() {
        this.find(false);
    }

    private void find(boolean next) {
        String incrementalSearchText = this.incrementalSearchTextField.getText();
        boolean empty = incrementalSearchText.length() <= 0;
        this.incrementalSearchTextField.getDocument().removeDocumentListener(this.incrementalSearchTextFieldListener);
        for (int i = this.incrementalSearchComboBox.getItemCount() - 1; i >= 0; --i) {
            String item = (String)this.incrementalSearchComboBox.getItemAt(i);
            if (!item.equals(incrementalSearchText)) continue;
            this.incrementalSearchComboBox.removeItemAt(i);
        }
        ((MutableComboBoxModel)this.incrementalSearchComboBox.getModel()).insertElementAt(incrementalSearchText, 0);
        this.incrementalSearchComboBox.setSelectedIndex(0);
        this.incrementalSearchTextField.getDocument().addDocumentListener(this.incrementalSearchTextFieldListener);
        FindSupport findSupport = FindSupport.getFindSupport();
        this.findProps.put("find-what", incrementalSearchText);
        this.findProps.put("find-match-case", this.matchCaseCheckBox.isSelected());
        this.findProps.put("find-whole-words", this.wholeWordsCheckBox.isSelected());
        this.findProps.put("find-reg-exp", this.regexpCheckBox.isSelected());
        this.findProps.put("find-backward-search", Boolean.FALSE);
        this.findProps.put("find-inc-search", Boolean.TRUE);
        this.findProps.put("find-highlight-search", !empty && this.highlightCheckBox.isSelected());
        findSupport.putFindProperties(this.findProps);
        if (findSupport.find(this.findProps, !next) || empty) {
            this.incrementalSearchTextField.setForeground(UIManager.getColor("textText"));
            this.searched = true;
        } else {
            this.incrementalSearchTextField.setForeground(NOT_FOUND);
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void processButton(AbstractButton button) {
        button.setMargin(BUTTON_INSETS);
    }

    private void initBlockSearch() {
        JTextComponent c = EditorRegistry.lastFocusedComponent();
        String selText = null;
        int startSelection = 0;
        int endSelection = 0;
        boolean blockSearchVisible = false;
        if (c != null) {
            startSelection = c.getSelectionStart();
            endSelection = c.getSelectionEnd();
            Document doc = c.getDocument();
            if (doc instanceof BaseDocument) {
                BaseDocument bdoc = (BaseDocument)doc;
                try {
                    int startLine = Utilities.getLineOffset((BaseDocument)bdoc, (int)startSelection);
                    int endLine = Utilities.getLineOffset((BaseDocument)bdoc, (int)endSelection);
                    if (endLine > startLine) {
                        blockSearchVisible = true;
                    }
                }
                catch (BadLocationException ble) {
                    // empty catch block
                }
            }
            if (!blockSearchVisible) {
                selText = c.getSelectedText();
                if (selText != null && selText.length() > 0) {
                    int n = selText.indexOf(10);
                    if (n >= 0) {
                        selText = selText.substring(0, n);
                    }
                    this.incrementalSearchTextField.setText(selText);
                } else {
                    String findWhat = (String)FindSupport.getFindSupport().getFindProperty("find-what");
                    if (findWhat != null && findWhat.length() > 0) {
                        this.incrementalSearchTextField.getDocument().removeDocumentListener(this.incrementalSearchTextFieldListener);
                        this.incrementalSearchTextField.setText(findWhat);
                        this.incrementalSearchTextField.getDocument().addDocumentListener(this.incrementalSearchTextFieldListener);
                    }
                }
            }
            int blockSearchStartOffset = blockSearchVisible ? startSelection : 0;
            int blockSearchEndOffset = blockSearchVisible ? endSelection : 0;
            try {
                this.findProps.put("find-block-search", blockSearchVisible);
                this.findProps.put("find-block-search-start", doc.createPosition(blockSearchStartOffset));
                this.findProps.put("find-block-search-end", doc.createPosition(blockSearchEndOffset));
                FindSupport.getFindSupport().setBlockSearchHighlight(blockSearchStartOffset, blockSearchEndOffset);
            }
            catch (BadLocationException ble) {
                this.findProps.put("find-block-search", Boolean.FALSE);
                this.findProps.put("find-block-search-start", null);
                this.findProps.put("find-block-search-end", null);
            }
            FindSupport.getFindSupport().putFindProperties(this.findProps);
        }
    }

    private static <T> T findComponent(Container container, Class<T> componentClass, int depth) {
        if (depth > 0) {
            for (Component c : container.getComponents()) {
                Component target;
                if (componentClass.isAssignableFrom(c.getClass())) {
                    target = c;
                    return (T)target;
                }
                if (!(c instanceof Container) || (target = SearchBar.findComponent((Container)c, componentClass, depth - 1)) == null) continue;
                return (T)target;
            }
        }
        return null;
    }

    private boolean getMatchCase() {
        Boolean b = (Boolean)this.findProps.get("find-match-case");
        return b != null ? b : false;
    }

    private void switchMatchCase() {
        this.findProps.put("find-match-case", !this.getMatchCase());
    }

    private boolean getWholeWords() {
        Boolean b = (Boolean)this.findProps.get("find-whole-words");
        return b != null ? b : false;
    }

    private void switchWholeWords() {
        this.findProps.put("find-match-case", !this.getWholeWords());
    }

    private boolean getRegExp() {
        Boolean b = (Boolean)this.findProps.get("find-reg-exp");
        return b != null ? b : false;
    }

    private void switchRegExp() {
        this.findProps.put("find-match-case", !this.getRegExp());
    }

    private boolean getHighlightResults() {
        Boolean b = (Boolean)this.findProps.get("find-highlight-search");
        return b != null ? b : false;
    }

    private void switchHighlightResults() {
        this.findProps.put("find-match-case", !this.getHighlightResults());
    }

    public static class IncrementalSearchBackwardAction
    extends BaseAction {
        static final long serialVersionUID = -1L;

        public IncrementalSearchBackwardAction() {
            super(SearchBar.INCREMENTAL_SEARCH_BACKWARD, 32);
            this.putValue("ShortDescription", NbBundle.getMessage(IncrementalSearchBackwardAction.class, (String)SearchBar.INCREMENTAL_SEARCH_BACKWARD));
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            EditorUI eui;
            if (target != null && (eui = Utilities.getEditorUI((JTextComponent)target)) != null) {
                SearchBar issb;
                JComponent comp;
                JComponent jComponent = comp = eui.hasExtComponent() ? eui.getExtComponent() : null;
                if (comp != null && (issb = (SearchBar)SearchBar.findComponent(comp, SearchBar.class, 5)) != null) {
                    issb.gainFocus();
                }
            }
        }
    }

    public static class IncrementalSearchForwardAction
    extends BaseAction {
        static final long serialVersionUID = -1L;

        public IncrementalSearchForwardAction() {
            super(SearchBar.INCREMENTAL_SEARCH_FORWARD, 32);
            this.putValue("ShortDescription", NbBundle.getMessage(IncrementalSearchForwardAction.class, (String)SearchBar.INCREMENTAL_SEARCH_FORWARD));
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            EditorUI eui;
            if (target != null && (eui = Utilities.getEditorUI((JTextComponent)target)) != null) {
                SearchBar issb;
                JComponent comp;
                JComponent jComponent = comp = eui.hasExtComponent() ? eui.getExtComponent() : null;
                if (comp != null && (issb = (SearchBar)SearchBar.findComponent(comp, SearchBar.class, 5)) != null) {
                    issb.gainFocus();
                }
            }
        }
    }

    public static final class Factory
    implements SideBarFactory {
        public JComponent createSideBar(JTextComponent target) {
            return new SearchBar(target);
        }
    }
}

