/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.lib2.view.DocumentView;
import org.netbeans.modules.editor.lib2.view.EditorView;
import org.netbeans.modules.editor.lib2.view.HighlightsViewPart;
import org.netbeans.modules.editor.lib2.view.HighlightsViewUtils;
import org.netbeans.modules.editor.lib2.view.ParagraphView;
import org.netbeans.modules.editor.lib2.view.TextLayoutPart;
import org.netbeans.modules.editor.lib2.view.TextLayoutUtils;
import org.netbeans.modules.editor.lib2.view.ViewUtils;

public class HighlightsView
extends EditorView {
    private static final Logger LOG = Logger.getLogger(HighlightsView.class.getName());
    private int rawOffset;
    private int length;
    private final AttributeSet attributes;
    private Object textLayoutOrPart;

    public HighlightsView(int offset, int length, AttributeSet attributes) {
        super(null);
        assert (length > 0) : "length=" + length + " <= 0";
        this.rawOffset = offset;
        this.length = length;
        this.attributes = attributes;
    }

    @Override
    public float getPreferredSpan(int axis) {
        float span = axis == 0 ? Math.abs(TextLayoutUtils.getWidth(this.layout(), this.length)) : TextLayoutUtils.getHeight(this.layout());
        return ViewUtils.ceilFractions(span);
    }

    @Override
    public int getRawOffset() {
        return this.rawOffset;
    }

    @Override
    public void setRawOffset(int rawOffset) {
        this.rawOffset = rawOffset;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public int getStartOffset() {
        EditorView.Parent parent = (EditorView.Parent)((Object)this.getParent());
        return parent != null ? parent.getViewOffset(this.rawOffset) : this.rawOffset;
    }

    @Override
    public int getEndOffset() {
        return this.getStartOffset() + this.getLength();
    }

    @Override
    public Document getDocument() {
        View parent = this.getParent();
        return parent != null ? parent.getDocument() : null;
    }

    @Override
    public AttributeSet getAttributes() {
        return this.attributes;
    }

    Object layout() {
        if (this.textLayoutOrPart == null) {
            this.getParagraphView().initTextLayouts();
        }
        return this.textLayoutOrPart;
    }

    Object layoutRaw() {
        return this.layout();
    }

    void setLayout(Object layoutOrPart) {
        this.textLayoutOrPart = layoutOrPart;
    }

    TextLayout createPartTextLayout(int shift, int length) {
        DocumentView docView = this.getDocumentView();
        Document doc = docView.getDocument();
        CharSequence docText = DocumentUtilities.getText((Document)doc);
        int startOffset = this.getStartOffset();
        String text = ((Object)docText.subSequence(startOffset + shift, startOffset + shift + length)).toString();
        return docView.createTextLayout(text, this.getAttributes());
    }

    ParagraphView getParagraphView() {
        return (ParagraphView)this.getParent();
    }

    DocumentView getDocumentView() {
        ParagraphView paragraphView = this.getParagraphView();
        return paragraphView != null ? paragraphView.getDocumentView() : null;
    }

    @Override
    public Shape modelToViewChecked(int offset, Shape alloc, Position.Bias bias) {
        return this.modelToViewChecked(offset, alloc, bias, -1);
    }

    public Shape modelToViewChecked(int offset, Shape alloc, Position.Bias bias, int index) {
        Shape ret;
        int relOffset = Math.max(0, offset - this.getStartOffset());
        Object layout = this.layout();
        if (layout instanceof TextLayoutPart) {
            TextLayoutPart part = (TextLayoutPart)layout;
            ParagraphView paragraphView = this.getParagraphView();
            if (paragraphView != null) {
                if (index == -1) {
                    index = paragraphView.getViewIndex(this.getStartOffset());
                }
                int layoutStartViewIndex = index - part.index();
                Rectangle2D.Double textLayoutBounds = ViewUtils.shape2Bounds(alloc);
                double relX = paragraphView.getViewVisualOffset(index) - paragraphView.getViewVisualOffset(layoutStartViewIndex);
                textLayoutBounds.x -= relX;
                textLayoutBounds.width = part.textLayoutWidth();
                ret = HighlightsViewUtils.indexToView(part.textLayout(), textLayoutBounds, part.offsetShift() + relOffset, bias, part.offsetShift() + this.getLength(), alloc);
            } else {
                ret = alloc;
            }
        } else {
            TextLayout textLayout = (TextLayout)layout;
            ret = HighlightsViewUtils.indexToView(textLayout, null, relOffset, bias, this.getLength(), alloc);
        }
        return ret;
    }

    @Override
    public int viewToModelChecked(double x, double y, Shape alloc, Position.Bias[] biasReturn) {
        return this.viewToModelChecked(x, y, alloc, biasReturn, -1);
    }

    public int viewToModelChecked(double x, double y, Shape alloc, Position.Bias[] biasReturn, int index) {
        int offset;
        Object layout = this.layout();
        if (layout instanceof TextLayoutPart) {
            TextLayoutPart part = (TextLayoutPart)layout;
            ParagraphView paragraphView = this.getParagraphView();
            if (paragraphView != null) {
                if (index == -1) {
                    index = paragraphView.getViewIndex(this.getStartOffset());
                }
                int layoutStartViewIndex = index - part.index();
                Rectangle2D.Double textLayoutBounds = ViewUtils.shape2Bounds(alloc);
                double relX = paragraphView.getViewVisualOffset(index) - paragraphView.getViewVisualOffset(layoutStartViewIndex);
                textLayoutBounds.x -= relX;
                textLayoutBounds.width = part.textLayoutWidth();
                offset = HighlightsViewUtils.viewToIndex(part.textLayout(), x, textLayoutBounds, biasReturn) + this.getStartOffset() - part.offsetShift();
            } else {
                offset = this.getStartOffset();
            }
        } else {
            TextLayout textLayout = (TextLayout)layout;
            offset = HighlightsViewUtils.viewToIndex(textLayout, x, alloc, biasReturn) + this.getStartOffset();
        }
        return offset;
    }

    @Override
    public int getNextVisualPositionFromChecked(int offset, Position.Bias bias, Shape alloc, int direction, Position.Bias[] biasRet) {
        int textLayoutStartOffset;
        TextLayout textLayout;
        Object layout = this.layout();
        int startOffset = this.getStartOffset();
        if (layout instanceof TextLayoutPart) {
            TextLayoutPart part = (TextLayoutPart)layout;
            textLayout = part.textLayout();
            textLayoutStartOffset = startOffset - part.offsetShift();
        } else {
            textLayout = (TextLayout)layout;
            textLayoutStartOffset = startOffset;
        }
        return HighlightsViewUtils.getNextVisualPosition(offset, bias, alloc, direction, biasRet, textLayout, textLayoutStartOffset, startOffset, this.getLength(), this.getDocumentView());
    }

    @Override
    public void paint(Graphics2D g, Shape alloc, Rectangle clipBounds) {
        Object layout = this.layout();
        if (layout instanceof TextLayoutPart) {
            throw new IllegalStateException("Invalid rendering of layout part");
        }
        TextLayout textLayout = (TextLayout)layout;
        HighlightsViewUtils.paint(g, alloc, clipBounds, this, textLayout, 0, this.getLength());
    }

    void partPaintForeground(Graphics2D g, Shape alloc, Shape textLayoutAlloc, Rectangle clipBounds) {
        HighlightsViewUtils.partPaintForeground(g, alloc, (TextLayoutPart)this.layout(), textLayoutAlloc, this.getAttributes(), this.getDocumentView());
    }

    void partPaintBackground(Graphics2D g, Shape alloc, Shape textLayoutAlloc, Rectangle clipBounds) {
        HighlightsViewUtils.partPaintBackground(g, alloc, (TextLayoutPart)this.layout(), textLayoutAlloc, this.getAttributes(), this.getDocumentView());
    }

    @Override
    public View breakView(int axis, int offset, float x, float len) {
        int textLayoutIndex;
        TextLayout textLayout;
        Object part;
        Object layout = this.layout();
        if (layout instanceof TextLayoutPart) {
            part = (TextLayoutPart)layout;
            textLayout = ((TextLayoutPart)part).textLayout();
            textLayoutIndex = ((TextLayoutPart)part).offsetShift();
        } else {
            textLayout = (TextLayout)layout;
            textLayoutIndex = 0;
        }
        part = HighlightsViewUtils.breakView(axis, offset, x, len, this, 0, this.getLength(), textLayout, textLayoutIndex);
        return part != null ? part : this;
    }

    @Override
    public View createFragment(int p0, int p1) {
        int startOffset = this.getStartOffset();
        ViewUtils.checkFragmentBounds(p0, p1, startOffset, this.getLength());
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("HV.createFragment(" + p0 + "," + p1 + "): <" + this.getStartOffset() + "," + this.getEndOffset() + ">\n");
        }
        return new HighlightsViewPart(this, p0 - startOffset, p1 - p0);
    }

    @Override
    protected String getDumpName() {
        return "HV";
    }

    @Override
    protected StringBuilder appendViewInfo(StringBuilder sb, int indent, int importantChildIndex) {
        super.appendViewInfo(sb, indent, importantChildIndex);
        sb.append(" L=");
        if (this.textLayoutOrPart == null) {
            sb.append("<NULL>");
        } else if (this.textLayoutOrPart instanceof TextLayoutPart) {
            TextLayoutPart part = (TextLayoutPart)this.textLayoutOrPart;
            sb.append(part.toStringShort());
        } else {
            sb.append("TL");
            sb.append(TextLayoutUtils.toStringShort((TextLayout)this.textLayoutOrPart));
        }
        return sb;
    }

    public String toString() {
        return this.appendViewInfo(new StringBuilder(200), 0, -1).toString();
    }
}

