/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.util.Collections;
import java.util.EventListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.lib2.highlighting.HighlightingManager;
import org.netbeans.modules.editor.lib2.highlighting.HighlightsSequenceEx;
import org.netbeans.modules.editor.lib2.view.EditorView;
import org.netbeans.modules.editor.lib2.view.EditorViewFactory;
import org.netbeans.modules.editor.lib2.view.HighlightsView;
import org.netbeans.modules.editor.lib2.view.NewlineView;
import org.netbeans.modules.editor.lib2.view.TabView;
import org.netbeans.modules.editor.lib2.view.ViewUtils;
import org.netbeans.spi.editor.highlighting.HighlightsChangeEvent;
import org.netbeans.spi.editor.highlighting.HighlightsChangeListener;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.openide.util.WeakListeners;

public final class HighlightsViewFactory
extends EditorViewFactory
implements HighlightsChangeListener {
    private static final Logger LOG = Logger.getLogger(HighlightsViewFactory.class.getName());
    private final HighlightsContainer highlightsContainer;
    private CharSequence docText;
    private Element lineElementRoot;
    private int lineIndex;
    private int lineEndOffset;
    private HighlightsSequence highlightsSequence;
    private int highlightStartOffset;
    private int highlightEndOffset;
    private AttributeSet highlightAttributes;
    private int usageCount = 0;

    public HighlightsViewFactory(JTextComponent component) {
        super(component);
        this.highlightsContainer = HighlightingManager.getInstance().getHighlights(component, null);
        this.highlightsContainer.addHighlightsChangeListener((HighlightsChangeListener)WeakListeners.create(HighlightsChangeListener.class, (EventListener)this, (Object)this.highlightsContainer));
    }

    @Override
    public void restart(int startOffset, int matchOffset) {
        if (this.usageCount != 0) {
            throw new IllegalStateException("Race condition: usageCount = " + this.usageCount);
        }
        ++this.usageCount;
        this.docText = DocumentUtilities.getText((Document)this.document());
        this.lineElementRoot = this.document().getDefaultRootElement();
        assert (this.lineElementRoot != null) : "lineElementRoot is null.";
        this.lineIndex = this.lineElementRoot.getElementIndex(startOffset);
        this.lineEndOffset = this.lineElementRoot.getElement(this.lineIndex).getEndOffset();
        this.highlightEndOffset = Integer.MIN_VALUE;
    }

    @Override
    public int nextViewStartOffset(int offset) {
        return offset;
    }

    @Override
    public EditorView createView(int startOffset, int limitOffset) {
        assert (startOffset < limitOffset) : "startOffset=" + startOffset + " >= limitOffset=" + limitOffset;
        this.updateHighlight(startOffset);
        this.updateLineEndOffset(startOffset);
        if (startOffset == this.lineEndOffset - 1) {
            return new NewlineView(startOffset, startOffset >= this.highlightStartOffset && startOffset + 1 <= this.highlightEndOffset ? this.highlightAttributes : null);
        }
        if (startOffset < this.highlightStartOffset) {
            int endOffset = Math.min(Math.min(this.highlightStartOffset, limitOffset), this.lineEndOffset - 1);
            return this.createHighlightsView(startOffset, endOffset - startOffset, null);
        }
        int endOffset = Math.min(Math.min(this.highlightEndOffset, limitOffset), this.lineEndOffset - 1);
        return this.createHighlightsView(startOffset, endOffset - startOffset, this.highlightAttributes);
    }

    @Override
    public int viewEndOffset(int startOffset, int limitOffset) {
        this.updateLineEndOffset(startOffset);
        return Math.min(this.lineEndOffset, limitOffset);
    }

    private EditorView createHighlightsView(int startOffset, int length, AttributeSet attrs) {
        if (length <= 0) {
            throw new IllegalStateException("startOffset=" + startOffset + ", length=" + length + ", highlight: <" + this.highlightStartOffset + "," + this.highlightEndOffset + ">, lineEndOffset=" + this.lineEndOffset + ", docText.length()=" + this.docText.length());
        }
        boolean tabs = this.docText.charAt(startOffset) == '\t';
        for (int i = 1; i < length; ++i) {
            if (tabs == (this.docText.charAt(startOffset + i) == '\t')) continue;
            length = i;
            break;
        }
        return tabs ? new TabView(startOffset, length, attrs) : new HighlightsView(startOffset, length, attrs);
    }

    private void updateLineEndOffset(int offset) {
        if (this.usageCount != 1) {
            throw new IllegalStateException("Missing factory restart: usageCount=" + this.usageCount);
        }
        while (this.lineEndOffset <= offset) {
            ++this.lineIndex;
            Element line = this.lineElementRoot.getElement(this.lineIndex);
            this.lineEndOffset = line.getEndOffset();
        }
    }

    private void updateHighlight(int offset) {
        if (offset >= this.highlightEndOffset) {
            if (this.highlightsSequence == null && this.highlightEndOffset == Integer.MIN_VALUE) {
                this.highlightsSequence = this.highlightsContainer.getHighlights(offset, Integer.MAX_VALUE);
            }
            while (this.highlightsSequence != null) {
                while (this.highlightsSequence instanceof HighlightsSequenceEx && ((HighlightsSequenceEx)this.highlightsSequence).isStale()) {
                    this.highlightsSequence = this.highlightsContainer.getHighlights(offset, Integer.MAX_VALUE);
                }
                if (this.highlightsSequence.moveNext()) {
                    this.highlightStartOffset = this.highlightsSequence.getStartOffset();
                    this.highlightEndOffset = this.highlightsSequence.getEndOffset();
                    this.highlightAttributes = this.highlightsSequence.getAttributes();
                    if (this.highlightStartOffset < this.highlightEndOffset) {
                        if (LOG.isLoggable(Level.FINEST)) {
                            LOG.fine("Highlight: <" + this.highlightStartOffset + "," + this.highlightEndOffset + "> " + ViewUtils.toString(this.highlightAttributes) + "\n");
                        }
                        if (offset >= this.highlightEndOffset) continue;
                        break;
                    }
                    if (this.highlightStartOffset <= this.highlightEndOffset) continue;
                    LOG.info("Invalid highlight: <" + this.highlightStartOffset + "," + this.highlightEndOffset + ">\n");
                    continue;
                }
                this.highlightsSequence = null;
                this.highlightAttributes = null;
                this.highlightStartOffset = Integer.MAX_VALUE;
                this.highlightEndOffset = Integer.MAX_VALUE;
            }
        }
    }

    @Override
    public void finish() {
        this.docText = null;
        this.lineElementRoot = null;
        this.lineIndex = -1;
        this.lineEndOffset = -1;
        this.highlightsSequence = null;
        this.highlightStartOffset = Integer.MAX_VALUE;
        this.highlightEndOffset = Integer.MAX_VALUE;
        this.highlightAttributes = null;
        --this.usageCount;
    }

    @Override
    public void highlightChanged(HighlightsChangeEvent event) {
        int startOffset = event.getStartOffset();
        int endOffset = event.getEndOffset();
        int docTextLength = this.document().getLength() + 1;
        assert (startOffset >= 0) : "startOffset=" + startOffset + " < 0";
        assert (endOffset >= 0) : "startOffset=" + endOffset + " < 0";
        startOffset = Math.min(startOffset, docTextLength);
        endOffset = Math.min(endOffset, docTextLength);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINER, "highlightChanged: event:<{0}{1}{2}>, thread:{3}\n", new Object[]{startOffset, Character.valueOf(','), endOffset, Thread.currentThread()});
        }
        if (startOffset <= endOffset) {
            this.fireEvent(Collections.singletonList(HighlightsViewFactory.createChange(startOffset, endOffset)));
        }
    }

    public static final class HighlightsFactory
    implements EditorViewFactory.Factory {
        @Override
        public EditorViewFactory createEditorViewFactory(JTextComponent component) {
            return new HighlightsViewFactory(component);
        }

        @Override
        public int importance() {
            return 0;
        }
    }
}

