/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.archive.mtz;

import com.paterva.maltego.archive.mtz.EntityCategoryEntry;
import com.paterva.maltego.archive.mtz.Entry;
import com.paterva.maltego.archive.mtz.FileStoreFileEntry;
import com.paterva.maltego.archive.mtz.ImageCacheFileEntry;
import com.paterva.maltego.archive.mtz.ImageCacheIndexEntry;
import com.paterva.maltego.archive.mtz.MaltegoEntityEntry;
import com.paterva.maltego.archive.mtz.MaltegoGraphEntry;
import com.paterva.maltego.archive.mtz.TransformDefinitionEntry;
import com.paterva.maltego.archive.mtz.TransformDescriptorEntry;
import com.paterva.maltego.archive.mtz.TransformSeedEntry;
import com.paterva.maltego.archive.mtz.TransformServerEntry;
import com.paterva.maltego.archive.mtz.TransformSetEntry;
import com.paterva.maltego.archive.mtz.TransformSettingsEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.ZipInputStream;
import net.lingala.zip4j.model.FileHeader;

public class MaltegoArchive {
    private ZipFile _file;
    private Map<String, FileHeader> _paths;

    public MaltegoArchive(ZipFile zipFile) {
        this._file = zipFile;
    }

    public <T> ZipInputStream getInputStream(String string) throws ZipException {
        return this._file.getInputStream(this._paths.get(string));
    }

    private static <TEntry extends Entry> String getTypeName(Class<TEntry> clazz) {
        if (clazz == MaltegoEntityEntry.class) {
            return "entity";
        }
        if (clazz == MaltegoGraphEntry.class) {
            return "graphml";
        }
        if (clazz == TransformSeedEntry.class) {
            return "seed";
        }
        if (clazz == TransformSetEntry.class) {
            return "set";
        }
        if (clazz == TransformServerEntry.class) {
            return "tas";
        }
        if (clazz == TransformDescriptorEntry.class) {
            return "transform";
        }
        if (clazz == TransformSettingsEntry.class) {
            return "transformsettings";
        }
        if (clazz == TransformDefinitionEntry.class) {
            return "definition";
        }
        if (clazz == EntityCategoryEntry.class) {
            return "category";
        }
        if (clazz == ImageCacheIndexEntry.class) {
            return "imgcache";
        }
        if (clazz == ImageCacheFileEntry.class) {
            return "png";
        }
        if (clazz == FileStoreFileEntry.class) {
            return "file";
        }
        return null;
    }

    private static <TEntry extends Entry> String getFolderName(Class<TEntry> clazz) {
        if (clazz == MaltegoEntityEntry.class) {
            return "Entities";
        }
        if (clazz == MaltegoGraphEntry.class) {
            return "Graphs";
        }
        if (clazz == TransformSeedEntry.class) {
            return "Seeds";
        }
        if (clazz == TransformSetEntry.class) {
            return "TransformSets";
        }
        if (clazz == TransformServerEntry.class) {
            return "Servers";
        }
        if (clazz == TransformDescriptorEntry.class) {
            return "TransformRepositories";
        }
        if (clazz == TransformSettingsEntry.class) {
            return "TransformRepositories";
        }
        if (clazz == TransformDefinitionEntry.class) {
            return "TransformRepositories";
        }
        if (clazz == EntityCategoryEntry.class) {
            return "EntityCategories";
        }
        if (clazz == ImageCacheIndexEntry.class) {
            return "Cache";
        }
        if (clazz == ImageCacheFileEntry.class) {
            return "Cache/Images";
        }
        return "";
    }

    public <TEntry extends Entry> List<TEntry> createEntries(Class<TEntry> clazz, String string) throws ZipException {
        ArrayList<TEntry> arrayList = new ArrayList<TEntry>();
        List<String> list = this.getPaths(clazz, string);
        for (String string2 : list) {
            arrayList.add(this.createEntry(clazz, string2));
        }
        return arrayList;
    }

    public <TEntry extends Entry> TEntry createEntry(Class<TEntry> clazz, String string) {
        if (MaltegoEntityEntry.class.equals(clazz)) {
            return (TEntry)((Entry)clazz.cast(new MaltegoEntityEntry(string)));
        }
        if (MaltegoGraphEntry.class.equals(clazz)) {
            return (TEntry)((Entry)clazz.cast(new MaltegoGraphEntry(string)));
        }
        if (TransformSeedEntry.class.equals(clazz)) {
            return (TEntry)((Entry)clazz.cast(new TransformSeedEntry(string)));
        }
        if (TransformSetEntry.class.equals(clazz)) {
            return (TEntry)((Entry)clazz.cast(new TransformSetEntry(string)));
        }
        if (TransformServerEntry.class.equals(clazz)) {
            return (TEntry)((Entry)clazz.cast(new TransformServerEntry(string)));
        }
        if (TransformDescriptorEntry.class.equals(clazz)) {
            return (TEntry)((Entry)clazz.cast(new TransformDescriptorEntry(string)));
        }
        if (TransformSettingsEntry.class.equals(clazz)) {
            return (TEntry)((Entry)clazz.cast(new TransformSettingsEntry(string)));
        }
        if (TransformDefinitionEntry.class.equals(clazz)) {
            return (TEntry)((Entry)clazz.cast(new TransformDefinitionEntry(string)));
        }
        if (EntityCategoryEntry.class.equals(clazz)) {
            return (TEntry)((Entry)clazz.cast(new EntityCategoryEntry(string)));
        }
        if (ImageCacheIndexEntry.class.equals(clazz)) {
            return (TEntry)((Entry)clazz.cast(new ImageCacheIndexEntry(string)));
        }
        if (ImageCacheFileEntry.class.equals(clazz)) {
            return (TEntry)((Entry)clazz.cast(new ImageCacheFileEntry(string)));
        }
        if (FileStoreFileEntry.class.equals(clazz)) {
            return (TEntry)((Entry)clazz.cast(new FileStoreFileEntry(string)));
        }
        throw new IllegalArgumentException("Unknown type: " + clazz);
    }

    public <TEntry extends Entry> List<String> getPaths(Class<TEntry> clazz, String string) throws ZipException {
        if (FileStoreFileEntry.class.equals(clazz)) {
            return this.getPaths("Files/" + string);
        }
        return this.getPaths(MaltegoArchive.getFolderName(clazz), MaltegoArchive.getTypeName(clazz));
    }

    public List<String> getPaths(String string, String string2) throws ZipException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string3 : this.getPaths().keySet()) {
            String[] stringArray = Entry.parse(string3);
            String string4 = stringArray[0];
            String string5 = stringArray[2];
            if (!string4.startsWith(string) || string2 != null && !string2.equals(string5)) continue;
            arrayList.add(string3);
        }
        return arrayList;
    }

    public List<String> getPaths(String string) throws ZipException {
        return this.getPaths(string, null);
    }

    private Map<String, FileHeader> getPaths() throws ZipException {
        if (this._paths == null) {
            this._paths = new HashMap<String, FileHeader>();
            List list = this._file.getFileHeaders();
            for (Object e : list) {
                FileHeader fileHeader;
                if (!(e instanceof FileHeader) || (fileHeader = (FileHeader)e).isDirectory()) continue;
                this._paths.put(fileHeader.getFileName(), fileHeader);
            }
        }
        return this._paths;
    }
}

