/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.archive.mtz;

import com.paterva.maltego.archive.mtz.Entry;
import com.paterva.maltego.archive.mtz.MaltegoArchive;
import com.paterva.maltego.archive.mtz.MaltegoGraphEntry;
import com.paterva.maltego.entity.api.EntityFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.ZipInputStream;
import yguard.A.A.D;

public class MaltegoArchiveReader {
    private MaltegoArchive _archive;

    public MaltegoArchiveReader(ZipFile zipFile) {
        this._archive = new MaltegoArchive(zipFile);
    }

    public D readGraph(String string, EntityFactory entityFactory) throws IOException {
        String string2 = "Graphs/" + string + "." + "graphml";
        MaltegoGraphEntry maltegoGraphEntry = new MaltegoGraphEntry(string2);
        if (maltegoGraphEntry != null) {
            maltegoGraphEntry.setEntityFactory(entityFactory);
            return this.read(maltegoGraphEntry);
        }
        return null;
    }

    public <T> T read(Entry<T> entry) throws IOException {
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = this._archive.getInputStream(entry.getName());
            T t = entry.read((InputStream)zipInputStream);
            return t;
        }
        catch (ZipException zipException) {
            throw new IOException(zipException);
        }
        finally {
            if (zipInputStream != null) {
                zipInputStream.close(true);
            }
        }
    }

    public <T, TEntry extends Entry<T>> List<T> readAll(Class<TEntry> clazz, String string) throws IOException {
        ArrayList<T> arrayList = new ArrayList<T>();
        try {
            List<TEntry> list = this._archive.createEntries(clazz, string);
            for (Entry entry : list) {
                arrayList.add(this.read(entry));
            }
        }
        catch (ZipException zipException) {
            throw new IOException(zipException);
        }
        return arrayList;
    }
}

